/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.cluster;

import com.codahale.metrics.MetricRegistry;
import edu.uci.ics.jung.graph.Graph;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.engine.cluster.AbstractClusterEngine;
import org.opennms.alec.engine.cluster.AlarmInSpaceTime;
import org.opennms.alec.engine.cluster.CEEdge;
import org.opennms.alec.engine.cluster.CEVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterEngine
extends AbstractClusterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterEngine.class);

    public ClusterEngine(MetricRegistry metrics) {
        super(metrics);
    }

    @Override
    public List<Cluster<AlarmInSpaceTime>> cluster(long timestampInMillis, Graph<CEVertex, CEEdge> g) {
        LinkedList<Cluster<AlarmInSpaceTime>> clusters = new LinkedList<Cluster<AlarmInSpaceTime>>();
        for (CEVertex v : g.getVertices()) {
            if (!v.hasAlarms()) continue;
            Cluster cluster = new Cluster();
            for (Alarm a : v.getAlarms()) {
                cluster.addPoint((Clusterable)new AlarmInSpaceTime(v, a));
            }
            clusters.add((Cluster<AlarmInSpaceTime>)cluster);
        }
        return clusters;
    }
}

