/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.cluster;

import com.google.common.base.Stopwatch;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opennms.alec.engine.cluster.CEEdge;
import org.opennms.alec.engine.cluster.CEVertex;
import org.opennms.alec.engine.cluster.GraphManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterableGraphManager
extends GraphManager {
    private static final Logger LOG = LoggerFactory.getLogger(FilterableGraphManager.class);
    private final BiPredicate<CEVertex, Graph<CEVertex, CEEdge>> dropVertexFilter;
    private final Graph<CEVertex, CEEdge> filteredGraph = new SparseMultigraph();

    private FilterableGraphManager(BiPredicate<CEVertex, Graph<CEVertex, CEEdge>> dropVertexFilter) {
        this.dropVertexFilter = dropVertexFilter;
    }

    public static FilterableGraphManager withFilter(BiPredicate<CEVertex, Graph<CEVertex, CEEdge>> dropVertexFilter) {
        return new FilterableGraphManager(Objects.requireNonNull(dropVertexFilter));
    }

    public Graph<CEVertex, CEEdge> getFilteredGraph() {
        return this.filteredGraph;
    }

    public List<CEVertex> getFilteredMatchingVertices(Predicate<CEVertex> vertexMustMatch) {
        return this.filteredGraph.getVertices().stream().filter(vertexMustMatch).collect(Collectors.toList());
    }

    public void updateAndFilter() {
        Stopwatch timeToFilterStopwatch = Stopwatch.createStarted();
        this.clearFilteredGraph();
        this.getGraph().getVertices().forEach(arg_0 -> this.filteredGraph.addVertex(arg_0));
        this.getGraph().getEdges().forEach(e -> {
            Collection incidentVertices = this.getGraph().getIncidentVertices(e);
            if (this.filteredGraph.getVertices().containsAll(incidentVertices)) {
                this.filteredGraph.addEdge(e, incidentVertices);
            }
        });
        long copyGraphTime = timeToFilterStopwatch.elapsed(TimeUnit.MILLISECONDS);
        LOG.debug("Copied graph in {}ms", (Object)copyGraphTime);
        this.recursivelyFilter(this.getGraph());
        LOG.debug("Filtered graph from {} vertices to {} vertices in {}ms", new Object[]{this.getGraph().getVertexCount(), this.filteredGraph.getVertexCount(), timeToFilterStopwatch.elapsed(TimeUnit.MILLISECONDS) - copyGraphTime});
    }

    private void recursivelyFilter(Graph<CEVertex, CEEdge> graph) {
        HashSet verticesToRemove = new HashSet();
        graph.getVertices().forEach(v -> {
            if (this.dropVertexFilter.test((CEVertex)v, graph)) {
                verticesToRemove.add(v);
            }
        });
        verticesToRemove.forEach(arg_0 -> this.filteredGraph.removeVertex(arg_0));
        if (!verticesToRemove.isEmpty()) {
            this.recursivelyFilter(this.filteredGraph);
        }
    }

    private void clearFilteredGraph() {
        HashSet verticesToRemove = new HashSet(this.filteredGraph.getVertices());
        verticesToRemove.forEach(arg_0 -> this.filteredGraph.removeVertex(arg_0));
    }
}

