/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.cluster;

import java.util.Objects;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.engine.cluster.CEVertex;

public class AlarmInSpaceTime
implements Clusterable {
    private final CEVertex vertex;
    private final Alarm alarm;
    private final double[] point;

    public AlarmInSpaceTime(CEVertex vertex, Alarm alarm) {
        this.vertex = Objects.requireNonNull(vertex);
        this.alarm = Objects.requireNonNull(alarm);
        this.point = new double[]{alarm.getTime(), vertex.getNumericId(), alarm.getFirstTime()};
    }

    public double[] getPoint() {
        return this.point;
    }

    public String getAlarmId() {
        return this.alarm.getId();
    }

    public Alarm getAlarm() {
        return this.alarm;
    }

    public long getAlarmTime() {
        return this.alarm.getTime();
    }

    public long getAlarmFirstTime() {
        return this.alarm.getFirstTime();
    }

    public CEVertex getVertex() {
        return this.vertex;
    }
}

