/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.cluster;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import edu.uci.ics.jung.graph.Graph;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.opennms.alec.engine.cluster.FilterableGraphManager;
import org.opennms.alec.engine.cluster.SolvableGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DijkstraSolvableGraph<V, E>
implements SolvableGraph<V> {
    private static final Logger LOG = LoggerFactory.getLogger(FilterableGraphManager.class);
    private final Graph<V, E> graphToSolve;
    private final ForkJoinPool threadPool;
    private final Map<V, SourceData> sourceMap = new HashMap<V, SourceData>();
    private final Function<E, Double> edgeWeightFunction;

    private DijkstraSolvableGraph(Graph<V, E> graphToSolve, Function<E, Double> edgeWeightFunction, int numThreads) {
        this.graphToSolve = graphToSolve;
        this.edgeWeightFunction = edgeWeightFunction;
        this.threadPool = new ForkJoinPool(numThreads);
    }

    public static <V, E> DijkstraSolvableGraph<V, E> newInstance(Graph<V, E> graphToSolve, Function<E, Double> edgeWeightFunction, int numThreads) {
        Objects.requireNonNull(graphToSolve);
        Objects.requireNonNull(edgeWeightFunction);
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0);
        return new DijkstraSolvableGraph<V, E>(graphToSolve, edgeWeightFunction, numThreads);
    }

    @Override
    public void solve(Collection<V> sourceVertices, Collection<V> targetVertices) {
        try {
            Stopwatch graphSolvingStopwatch = Stopwatch.createStarted();
            ((ForkJoinTask)this.threadPool.submit(() -> sourceVertices.parallelStream().forEach(v -> {
                this.getSourceData(v);
                this.solveTask(v, targetVertices);
            }))).get();
            LOG.debug("Solved {} source vertices in {}ms", (Object)sourceVertices.size(), (Object)graphSolvingStopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void solveTask(V source, Collection<V> targets) {
        SourceData sd = this.getSourceData(source);
        HashSet<V> to_get = new HashSet<V>();
        if (targets != null) {
            to_get.addAll(targets);
        }
        while (!sd.unknownVertices.isEmpty() && !to_get.isEmpty()) {
            Map.Entry p = sd.getNextVertex();
            Object v = p.getKey();
            double v_dist = p.getValue().doubleValue();
            to_get.remove(v);
            for (Object e : this.graphToSolve.getOutEdges(v)) {
                for (Object w : this.graphToSolve.getIncidentVertices(e)) {
                    if (sd.distances.containsKey(w)) continue;
                    double edge_weight = this.edgeWeightFunction.apply(e);
                    if (edge_weight < 0.0) {
                        throw new IllegalArgumentException("Edges weights must be non-negative");
                    }
                    double new_dist = v_dist + edge_weight;
                    if (!sd.estimatedDistances.containsKey(w)) {
                        sd.createRecord(w, e, new_dist);
                        continue;
                    }
                    double w_dist = (Double)sd.estimatedDistances.get(w);
                    if (!(new_dist < w_dist)) continue;
                    sd.update(w, e, new_dist);
                }
            }
        }
    }

    private synchronized SourceData getSourceData(V source) {
        SourceData sourceData = this.sourceMap.get(source);
        if (sourceData == null) {
            sourceData = new SourceData(source);
            this.sourceMap.put((SourceData)source, sourceData);
        }
        return sourceData;
    }

    @Override
    public void invalidate() {
        this.sourceMap.clear();
    }

    @Override
    public Number getDistance(V source, V target) {
        if (!this.graphToSolve.containsVertex(source)) {
            throw new RuntimeException("Graph does not contain source vertex " + source);
        }
        if (!this.graphToSolve.containsVertex(target)) {
            throw new RuntimeException("Graph does not contain target vertex " + target);
        }
        SourceData sd = this.sourceMap.get(source);
        if (sd == null) {
            throw new RuntimeException("Graph has not been solved yet");
        }
        return sd.distances.get(target);
    }

    @Override
    public void destroy() {
        this.threadPool.shutdownNow();
        this.invalidate();
    }

    protected class SourceData {
        LinkedHashMap<V, Number> distances = new LinkedHashMap();
        Map<V, Number> estimatedDistances = new HashMap();
        PriorityQueue<V> unknownVertices = new PriorityQueue(new VertexComparator(this.estimatedDistances));

        SourceData(V source) {
            DijkstraSolvableGraph.this.sourceMap.put((SourceData)source, this);
            this.estimatedDistances.put((Number)source, 0.0);
            this.unknownVertices.add(source);
        }

        Map.Entry<V, Number> getNextVertex() {
            Object v = this.unknownVertices.remove();
            Double dist = (Double)this.estimatedDistances.remove(v);
            this.distances.put((Number)v, dist);
            return new AbstractMap.SimpleImmutableEntry(v, dist);
        }

        void update(V dest, E tentative_edge, double new_dist) {
            this.estimatedDistances.put((Number)dest, new_dist);
            this.unknownVertices.remove(dest);
            this.unknownVertices.add(dest);
        }

        void createRecord(V w, E e, double new_dist) {
            this.estimatedDistances.put((Number)w, new_dist);
            this.unknownVertices.add(w);
        }
    }

    protected static class VertexComparator<V>
    implements Comparator<V> {
        private Map<V, Number> distances;

        VertexComparator(Map<V, Number> distances) {
            this.distances = distances;
        }

        @Override
        public int compare(V o1, V o2) {
            return ((Double)this.distances.get(o1)).compareTo((Double)this.distances.get(o2));
        }
    }
}

