/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.dbscan;

import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.DBSCANClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.opennms.alec.engine.cluster.AbstractClusterEngine;
import org.opennms.alec.engine.cluster.AlarmInSpaceTime;
import org.opennms.alec.engine.cluster.CEEdge;
import org.opennms.alec.engine.cluster.CEVertex;
import org.opennms.alec.engine.cluster.SpatialDistanceCalculator;
import org.opennms.alec.engine.dbscan.AlarmInSpaceTimeDistanceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBScanEngine
extends AbstractClusterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(DBScanEngine.class);
    public static final double DEFAULT_EPSILON = 100.0;
    public static final double DEFAULT_ALPHA = 144.47117699;
    public static final double DEFAULT_BETA = 0.55257784;
    private final double epsilon;
    private final AlarmInSpaceTimeDistanceMeasure distanceMeasure;

    public DBScanEngine() {
        this(100.0, 144.47117699, 0.55257784);
    }

    public DBScanEngine(double epsilon, double alpha, double beta) {
        this.epsilon = epsilon;
        this.distanceMeasure = new AlarmInSpaceTimeDistanceMeasure((SpatialDistanceCalculator)this, alpha, beta);
    }

    public List<Cluster<AlarmInSpaceTime>> cluster(long timestampInMillis, Graph<CEVertex, CEEdge> g) {
        List alarms = g.getVertices().stream().map(v -> v.getAlarms().stream().map(a -> new AlarmInSpaceTime(v, a)).collect(Collectors.toList())).flatMap(Collection::stream).sorted(Comparator.comparing(AlarmInSpaceTime::getAlarmTime).thenComparing(AlarmInSpaceTime::getAlarmId)).collect(Collectors.toList());
        if (alarms.size() < 1) {
            LOG.debug("{}: The graph contains no alarms. No clustering will be performed.", (Object)timestampInMillis);
            return null;
        }
        DBSCANClusterer clusterer = new DBSCANClusterer(this.epsilon, 1, (DistanceMeasure)this.distanceMeasure);
        return clusterer.cluster(alarms);
    }

    public double getDistanceBetween(double t1, double t2, double distance) {
        return this.distanceMeasure.compute(t1, t2, distance);
    }

    public AlarmInSpaceTimeDistanceMeasure getDistanceMeasure() {
        return this.distanceMeasure;
    }
}

