/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.dbscan.shell;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.alec.engine.api.Engine;
import org.opennms.alec.engine.api.EngineRegistry;
import org.opennms.alec.engine.cluster.AlarmInSpaceTime;
import org.opennms.alec.engine.dbscan.DBScanEngine;

@Command(scope="opennms-alec", name="dbscan-distance", description="Compute the distance between two alarms.")
@Service
public class DBScanDistance
implements Action {
    @Argument(index=0, name="alarm id 1", description="ID of the first alarm as stored in graph", required=true)
    private String alarmId1;
    @Argument(index=1, name="alarm id 2", description="ID of the second alarm as stored in graph", required=true)
    private String alarmId2;
    @Reference
    private List<EngineRegistry> engineRegistries = new ArrayList<EngineRegistry>();

    public Object execute() {
        DBScanEngine engine = this.findEngine();
        if (engine == null) {
            System.out.println("No suitable engine was found. Ensure the driver is running and initialized. Aborting.");
            return null;
        }
        String[] alarmIds = new String[]{this.alarmId1, this.alarmId2};
        Map alarmById = engine.findAlarmsWithIds(alarmIds);
        for (String alarmId : alarmIds) {
            boolean foundAllAlarms = true;
            if (!alarmById.containsKey(alarmId)) {
                System.out.printf("Did not find alarm with id '%s' in the graph.\n", alarmId);
                foundAllAlarms = false;
            }
            if (foundAllAlarms) continue;
            System.out.println("One or more alarms were not found. Aborting.");
            return null;
        }
        AlarmInSpaceTime a1 = (AlarmInSpaceTime)alarmById.get(this.alarmId1);
        AlarmInSpaceTime a2 = (AlarmInSpaceTime)alarmById.get(this.alarmId2);
        engine.resetHopCache();
        double distance = engine.getDistanceMeasure().compute(a1.getPoint(), a2.getPoint());
        System.out.printf("Distance is: %.4f\n", distance);
        return null;
    }

    private DBScanEngine findEngine() {
        for (EngineRegistry registry : this.engineRegistries) {
            for (Engine engine : registry.getEngines()) {
                if (!(engine instanceof DBScanEngine)) continue;
                return (DBScanEngine)engine;
            }
        }
        return null;
    }
}

