/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.dbscan;

import com.codahale.metrics.MetricRegistry;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.DBSCANClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.opennms.alec.engine.api.DistanceMeasureFactory;
import org.opennms.alec.engine.cluster.AbstractClusterEngine;
import org.opennms.alec.engine.cluster.AlarmInSpaceTime;
import org.opennms.alec.engine.cluster.CEEdge;
import org.opennms.alec.engine.cluster.CEVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBScanEngine
extends AbstractClusterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(DBScanEngine.class);
    public static final double DEFAULT_ALPHA = 144.47117699;
    public static final double DEFAULT_BETA = 0.55257784;
    public static final String DEFAULT_DISTANCE_MEASURE = "alarminspaceandtimedistance";
    private final double epsilon;
    private final org.opennms.alec.engine.api.DistanceMeasure distanceMeasure;

    public DBScanEngine(MetricRegistry metrics, double epsilon, double alpha, double beta, DistanceMeasureFactory distanceMeasureFactory) {
        super(metrics);
        LOG.debug("DBScanEngine configuration alpha: {} beta: {} epsilon: {} distanceMeasure: {}", new Object[]{alpha, beta, epsilon, distanceMeasureFactory.getName()});
        this.epsilon = epsilon;
        this.distanceMeasure = distanceMeasureFactory.createDistanceMeasure((Object)this, alpha, beta);
    }

    public List<Cluster<AlarmInSpaceTime>> cluster(long timestampInMillis, Graph<CEVertex, CEEdge> g) {
        LOG.debug("start DBSCan clustering: DistanceMeasure: {} Alpha: {} Beta: {} Epsilon: {}", new Object[]{this.distanceMeasure.getName(), this.distanceMeasure.getAlpha(), this.distanceMeasure.getBeta(), this.epsilon});
        List alarms = g.getVertices().stream().map(v -> v.getAlarms().stream().map(a -> new AlarmInSpaceTime(v, a)).collect(Collectors.toList())).flatMap(Collection::stream).sorted(Comparator.comparing(AlarmInSpaceTime::getAlarmTime).thenComparing(AlarmInSpaceTime::getAlarmId)).collect(Collectors.toList());
        if (alarms.size() < 1) {
            LOG.debug("{}: The graph contains no alarms. No clustering will be performed.", (Object)timestampInMillis);
            return null;
        }
        DBSCANClusterer clusterer = new DBSCANClusterer(this.epsilon, 1, (DistanceMeasure)this.distanceMeasure);
        return clusterer.cluster(alarms);
    }

    public double getDistanceBetween(double t1, double t2, double firstTimeA, double firstTimeB, double distance) {
        return this.distanceMeasure.compute(t1, t2, firstTimeA, firstTimeB, distance);
    }

    public org.opennms.alec.engine.api.DistanceMeasure getDistanceMeasure() {
        return this.distanceMeasure;
    }
}

