/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.dbscan;

import java.util.Objects;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.opennms.alec.engine.api.DistanceMeasure;
import org.opennms.alec.engine.cluster.SpatialDistanceCalculator;

public class AlarmInSpaceTimeDistanceMeasure
implements DistanceMeasure {
    public static final double DEFAULT_EPSILON = 100.0;
    private final SpatialDistanceCalculator spatialDistanceCalculator;
    private final double alpha;
    private final double beta;

    public AlarmInSpaceTimeDistanceMeasure(SpatialDistanceCalculator SpatialDistanceCalculator2, double alpha, double beta) {
        this.spatialDistanceCalculator = Objects.requireNonNull(SpatialDistanceCalculator2);
        this.alpha = alpha;
        this.beta = beta;
    }

    public double compute(double[] a, double[] b) throws DimensionMismatchException {
        double timeA = a[0];
        double timeB = b[0];
        long vertexIdA = (long)a[1];
        long vertexIdB = (long)b[1];
        double spatialDistance = 0.0;
        if (vertexIdA != vertexIdB && (spatialDistance = this.spatialDistanceCalculator.getSpatialDistanceBetween(vertexIdA, vertexIdB)) == 0.0) {
            spatialDistance = 2.147483647E9;
        }
        double distance = this.compute(timeA, timeB, spatialDistance);
        return distance;
    }

    public double compute(double timeA, double timeB, double spatialDistance) {
        return this.alpha * (this.beta * (Math.abs(timeA - timeB) / 1000.0 / 60.0) + (1.0 - this.beta) * spatialDistance / 100.0);
    }

    public double compute(double timeA, double timeB, double firstTimeA, double firstTimeB, double spatialDistance) {
        return this.compute(timeA, timeB, spatialDistance);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public String getName() {
        return "alarminspacetime";
    }
}

