/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.dbscan;

import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.opennms.alec.engine.api.DistanceMeasureFactory;
import org.opennms.alec.engine.api.EngineFactory;
import org.opennms.alec.engine.cluster.AbstractClusterEngine;
import org.opennms.alec.engine.dbscan.AlarmInSpaceAndTimeDistanceMeasureFactory;
import org.opennms.alec.engine.dbscan.DBScanEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBScanEngineFactory
implements EngineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DBScanEngineFactory.class);
    private double epsilon;
    private double alpha;
    private double beta;
    private String distanceMeasureFactoryName;
    private final AlarmInSpaceAndTimeDistanceMeasureFactory alarmInSpaceAndTimeDistanceMeasureFactory;
    private final Map<String, DistanceMeasureFactory> distanceMeasureFactoryMap;

    public DBScanEngineFactory(double alpha, double beta, double epsilon, String distanceMeasureFactoryName, AlarmInSpaceAndTimeDistanceMeasureFactory alarmInSpaceAndTimeDistanceMeasureFactory, Map<String, DistanceMeasureFactory> distanceMeasureFactoryMap) {
        this.epsilon = epsilon;
        this.alpha = alpha;
        this.beta = beta;
        this.distanceMeasureFactoryName = distanceMeasureFactoryName;
        this.alarmInSpaceAndTimeDistanceMeasureFactory = alarmInSpaceAndTimeDistanceMeasureFactory;
        this.distanceMeasureFactoryMap = distanceMeasureFactoryMap;
    }

    public String getName() {
        return "dbscan";
    }

    public String getNameConf() {
        return new StringJoiner(", ", this.getName() + "[", "]").add("epsilon=" + this.epsilon).add("alpha=" + this.alpha).add("beta=" + this.beta).add("distanceMeasure='" + this.distanceMeasureFactoryName + "'").toString();
    }

    public AbstractClusterEngine createEngine(MetricRegistry metrics) {
        Optional<DistanceMeasureFactory> factory = Optional.ofNullable(this.distanceMeasureFactoryMap.get(this.distanceMeasureFactoryName));
        if (factory.isPresent()) {
            return new DBScanEngine(metrics, this.epsilon, this.alpha, this.beta, factory.get());
        }
        LOG.warn("Wrong distance measure configuration {}, we'll use default {}", (Object)this.distanceMeasureFactoryName, (Object)this.alarmInSpaceAndTimeDistanceMeasureFactory.getName());
        this.distanceMeasureFactoryName = this.alarmInSpaceAndTimeDistanceMeasureFactory.getName();
        return new DBScanEngine(metrics, this.epsilon, this.alpha, this.beta, this.alarmInSpaceAndTimeDistanceMeasureFactory);
    }

    public EngineFactory getEngineFactory() {
        return this;
    }

    public String getParameters() {
        return String.format("engine: %s, alpha: %s, beta: %s, epsilon: %s, distanceMeasure: %s", this.getName(), this.getAlpha(), this.getBeta(), this.getEpsilon(), this.getDistanceMeasureFactoryName());
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public void setDistanceMeasureFactoryName(String distanceMeasureFactoryName) {
        this.distanceMeasureFactoryName = distanceMeasureFactoryName;
    }

    public String getDistanceMeasureFactoryName() {
        return this.distanceMeasureFactoryName;
    }
}

