/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.engine.dbscan;

import java.util.Objects;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.opennms.alec.engine.api.DistanceMeasure;
import org.opennms.alec.engine.cluster.SpatialDistanceCalculator;

public class HellingerDistanceMeasure
implements DistanceMeasure {
    public static final double DEFAULT_EPSILON = 75.0;
    private final SpatialDistanceCalculator spatialDistanceCalculator;
    private final double alpha;
    private final double beta;

    public HellingerDistanceMeasure(SpatialDistanceCalculator SpatialDistanceCalculator2, double alpha, double beta) {
        this.spatialDistanceCalculator = Objects.requireNonNull(SpatialDistanceCalculator2);
        this.alpha = alpha;
        this.beta = beta;
    }

    public double compute(double[] a, double[] b) throws DimensionMismatchException {
        double timeA = a[0];
        double timeB = b[0];
        double firstTimeA = a[2];
        double firstTimeB = b[2];
        long vertexIdA = (long)a[1];
        long vertexIdB = (long)b[1];
        double spatialDistance = 0.0;
        if (vertexIdA != vertexIdB && (spatialDistance = this.spatialDistanceCalculator.getSpatialDistanceBetween(vertexIdA, vertexIdB)) == 0.0) {
            spatialDistance = 2.147483647E9;
        }
        double distance = this.compute(timeA, timeB, firstTimeA, firstTimeB, spatialDistance);
        return distance;
    }

    public double compute(double timeA, double timeB, double firstTimeA, double firstTimeB, double spatialDistance) {
        double w = 4851.28;
        double bias = -1986.0;
        double var_a = Math.pow((timeA - firstTimeA) * w + bias, 2.0);
        double mean_a = 0.5 * (timeA + firstTimeA);
        double var_b = Math.pow((timeB - firstTimeB) * w + bias, 2.0);
        double mean_b = 0.5 * (timeB + firstTimeB);
        double var_sum = var_a + var_b;
        double eps_for_grad_sqrt = 1.0E-32;
        double hellinger = Math.sqrt(1.0 - Math.sqrt(2.0 * Math.sqrt(var_a) * Math.sqrt(var_b) / var_sum) * Math.exp(-0.25 * Math.pow(mean_a - mean_b, 2.0) / var_sum) + eps_for_grad_sqrt);
        return this.alpha * (this.beta * (Math.abs(timeA - timeB) / 1000.0 / 60.0) + (1.0 - this.beta) * spatialDistance / 100.0) * (1.0 + hellinger);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public String getName() {
        return "hellinger";
    }
}

