/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.data;

import org.opennms.alec.data.Agreement;
import org.opennms.alec.data.Configuration;
import org.opennms.alec.data.EngineParameter;

public class ConfigurationImpl
implements Configuration {
    private final Agreement agreement;
    private final EngineParameter engineParameter;

    private ConfigurationImpl(Builder builder) {
        this.agreement = builder.agreement;
        this.engineParameter = builder.engineParameter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ConfigurationImpl copy) {
        Builder builder = new Builder();
        builder.agreement = copy.getAgreement();
        builder.engineParameter = copy.getEngineParameter();
        return builder;
    }

    @Override
    public Agreement getAgreement() {
        return this.agreement;
    }

    @Override
    public EngineParameter getEngineParameter() {
        return this.engineParameter;
    }

    public static final class Builder {
        private Agreement agreement;
        private EngineParameter engineParameter;

        private Builder() {
        }

        public Builder agreement(Agreement val) {
            this.agreement = val;
            return this;
        }

        public Builder engineParameter(EngineParameter val) {
            this.engineParameter = val;
            return this;
        }

        public ConfigurationImpl build() {
            return new ConfigurationImpl(this);
        }
    }
}

