/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.data;

import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Optional;
import java.util.StringJoiner;
import org.opennms.alec.data.EngineParameter;

public class EngineParameterImpl
implements EngineParameter {
    public static final String DBSCAN = "dbscan";
    private final Double alpha;
    private final Double beta;
    private final Double epsilon;
    private final String distanceMeasureName;
    private final String engineName;
    private final String remoteUri;
    private final String token;
    private final boolean remote;

    private EngineParameterImpl(Builder builder) {
        this.alpha = builder.alpha;
        this.beta = builder.beta;
        this.epsilon = builder.epsilon;
        this.distanceMeasureName = builder.distanceMeasureName;
        this.engineName = builder.engineName;
        this.remoteUri = builder.remoteUri;
        this.token = builder.token;
        this.remote = builder.remote;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(EngineParameter copy) {
        Builder builder = new Builder();
        builder.alpha = copy.getAlpha();
        builder.beta = copy.getBeta();
        builder.epsilon = copy.getEpsilon();
        builder.distanceMeasureName = copy.getDistanceMeasureName();
        builder.engineName = copy.getEngineName();
        builder.remoteUri = copy.getRemoteUri();
        builder.token = copy.getToken();
        builder.remote = copy.isRemote();
        return builder;
    }

    @Override
    public Double getAlpha() {
        if (Optional.ofNullable(this.alpha).isEmpty()) {
            if (DBSCAN.equals(this.getEngineName())) {
                return 144.47117699;
            }
            return null;
        }
        return this.alpha;
    }

    @Override
    public Double getBeta() {
        if (Optional.ofNullable(this.beta).isEmpty()) {
            if (DBSCAN.equals(this.getEngineName())) {
                return 0.55257784;
            }
            return null;
        }
        return this.beta;
    }

    @Override
    public Double getEpsilon() {
        if (Optional.ofNullable(this.epsilon).isEmpty()) {
            switch (this.getDistanceMeasureName()) {
                case "hellinger": {
                    return 75.0;
                }
                case "alarminspacetime": {
                    return 100.0;
                }
            }
            if (this.engineName.equals("deeplearning")) {
                return 500.0;
            }
            return null;
        }
        return this.epsilon;
    }

    @Override
    public String getDistanceMeasureName() {
        if (Optional.ofNullable(this.distanceMeasureName).isEmpty()) {
            if (DBSCAN.equals(this.engineName)) {
                return "alarminspaceandtimedistance";
            }
            return "";
        }
        return this.distanceMeasureName;
    }

    @Override
    public String getEngineName() {
        return this.engineName;
    }

    @Override
    public String getRemoteUri() {
        return this.remoteUri;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean isRemote() {
        return this.remote;
    }

    public String toString() {
        return new StringJoiner(", ", EngineParameterImpl.class.getSimpleName() + "[", "]").add("alpha=" + this.alpha).add("beta=" + this.beta).add("epsilon=" + this.epsilon).add("distanceMeasureName='" + this.distanceMeasureName + "'").add("engineName='" + this.engineName + "'").add("remoteUri='" + this.remoteUri + "'").add("token='" + this.token + "'").add("remote=" + this.remote).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private Double alpha;
        private Double beta;
        private Double epsilon;
        private String distanceMeasureName;
        private String engineName;
        private String remoteUri;
        private String token;
        private boolean remote;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder alpha(Double val) {
            this.alpha = val;
            return this;
        }

        public Builder beta(Double val) {
            this.beta = val;
            return this;
        }

        public Builder epsilon(Double val) {
            this.epsilon = val;
            return this;
        }

        public Builder distanceMeasureName(String val) {
            this.distanceMeasureName = val;
            return this;
        }

        public Builder engineName(String val) {
            this.engineName = val;
            return this;
        }

        public Builder remoteUri(String val) {
            this.remoteUri = val;
            return this;
        }

        public Builder token(String val) {
            this.token = val;
            return this;
        }

        public Builder remote(boolean val) {
            this.remote = val;
            return this;
        }

        public EngineParameterImpl build() {
            return new EngineParameterImpl(this);
        }
    }
}

