/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.grpc;

import java.util.Objects;

public class GrpcConnectionConfig {
    private final String host;
    private final int port;

    public GrpcConnectionConfig(String host, int port) {
        this.host = Objects.requireNonNull(host);
        this.port = this.requirePositiveNumber(port);
    }

    private GrpcConnectionConfig(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
    }

    public static Builder newBuilder(GrpcConnectionConfig copy) {
        Builder builder = new Builder();
        builder.host = copy.getHost();
        builder.port = copy.getPort();
        return builder;
    }

    private int requirePositiveNumber(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(String.format("A positive number is required but was %s", value));
        }
        return value;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static final class Builder {
        private String host;
        private int port;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder host(String val) {
            this.host = val;
            return this;
        }

        public Builder port(int val) {
            this.port = val;
            return this;
        }

        public GrpcConnectionConfig build() {
            return new GrpcConnectionConfig(this);
        }
    }

    public static class GrpcConnectionConfigBuilder {
        private String host = "localhost";
    }
}

