/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.TimeUnit;
import org.opennms.alec.datasource.api.Situation;
import org.opennms.alec.grpc.GrpcConnectionConfig;
import org.opennms.alec.grpc.generated.AlecCollectionServiceGrpc;
import org.opennms.alec.grpc.generated.SituationSet;
import org.opennms.alec.mapper.SituationToSituationProto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SituationClient {
    private static final Logger LOG = LoggerFactory.getLogger(SituationClient.class);
    private final GrpcConnectionConfig grpcConnectionConfig;
    private final SituationToSituationProto mapper = new SituationToSituationProto();
    private AlecCollectionServiceGrpc.AlecCollectionServiceFutureStub futureStub;
    private ManagedChannel channel;
    private boolean doStore;

    public SituationClient(boolean doStore, GrpcConnectionConfig grpcConnectionConfig) {
        this.grpcConnectionConfig = grpcConnectionConfig;
        this.createChannel(doStore);
        this.doStore = doStore;
    }

    public void sendSituation(Situation situation, String systemId) {
        if (this.doStore) {
            SituationSet request = this.mapper.toSituationSet(situation, systemId);
            LOG.debug("Will try to send {} ...", (Object)request);
            this.futureStub.sendSituations(request);
        }
    }

    public void createChannel(boolean doStore) {
        if (this.channel != null) {
            this.destroy();
        }
        if (doStore) {
            this.channel = ManagedChannelBuilder.forAddress((String)this.grpcConnectionConfig.getHost(), (int)this.grpcConnectionConfig.getPort()).build();
            this.futureStub = AlecCollectionServiceGrpc.newFutureStub((Channel)this.channel);
        }
        this.doStore = doStore;
    }

    public void destroy() {
        try {
            if (this.channel != null) {
                this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

