/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.Response;
import org.opennms.alec.data.Agreement;
import org.opennms.alec.data.KeyEnum;
import org.opennms.alec.rest.ALECRestUtils;
import org.opennms.alec.rest.AgreementRest;
import org.opennms.alec.rest.SituationRest;
import org.opennms.integration.api.v1.distributed.KeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgreementRestImpl
implements AgreementRest {
    private static final Logger LOG = LoggerFactory.getLogger(AgreementRestImpl.class);
    private final ObjectMapper objectMapper;
    private final KeyValueStore<String> kvStore;
    private final SituationRest situationRest;

    public AgreementRestImpl(KeyValueStore<String> kvStore, SituationRest situationRest) {
        this.kvStore = kvStore;
        this.situationRest = situationRest;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public Response setAgreementConfiguration(Agreement agreement) {
        CompletableFuture future;
        LOG.debug("Set agreement configuration: {}", (Object)agreement);
        try {
            future = this.kvStore.putAsync(KeyEnum.AGREEMENT.toString(), (Object)this.objectMapper.writeValueAsString((Object)agreement), "ALEC_CONFIG");
            this.situationRest.updateAgreement(agreement.isAgreed());
        }
        catch (JsonProcessingException e) {
            return ALECRestUtils.somethingWentWrong(e);
        }
        return Response.ok(future.join()).build();
    }

    @Override
    public Response getAgreementConfiguration() {
        LOG.debug("Get agreement configuration");
        try {
            Optional agreementConfiguration = this.kvStore.get(KeyEnum.AGREEMENT.toString(), "ALEC_CONFIG");
            if (agreementConfiguration.isPresent()) {
                return Response.ok().entity(this.objectMapper.readValue((String)agreementConfiguration.get(), Agreement.class)).build();
            }
            return Response.noContent().build();
        }
        catch (JsonProcessingException e) {
            return ALECRestUtils.somethingWentWrong(e);
        }
    }
}

