/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.Response;
import org.opennms.alec.data.EngineParameter;
import org.opennms.alec.data.EngineParameterImpl;
import org.opennms.alec.data.KeyEnum;
import org.opennms.alec.driver.main.Driver;
import org.opennms.alec.engine.api.EngineFactory;
import org.opennms.alec.engine.api.EngineRegistry;
import org.opennms.alec.engine.cluster.ClusterEngineFactory;
import org.opennms.alec.engine.dbscan.DBScanEngineFactory;
import org.opennms.alec.engine.deeplearning.DeepLearningEngineFactory;
import org.opennms.alec.rest.ALECRestUtils;
import org.opennms.alec.rest.EngineRest;
import org.opennms.integration.api.v1.distributed.KeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineRestImpl
implements EngineRest {
    private static final Logger LOG = LoggerFactory.getLogger(EngineRestImpl.class);
    private final ObjectMapper objectMapper;
    private final KeyValueStore<String> kvStore;
    private final List<EngineFactory> engineFactories;
    private final Driver driver;

    public EngineRestImpl(KeyValueStore<String> kvStore, EngineRegistry engineRegistry, List<EngineFactory> engineFactories) {
        this.kvStore = kvStore;
        this.driver = (Driver)engineRegistry.getEngineRegistry();
        this.engineFactories = engineFactories;
        this.objectMapper = new ObjectMapper();
        EngineParameter engineParameter = (EngineParameter)this.getEngineConfiguration().getEntity();
        if (engineParameter != null) {
            this.setEngineConfiguration(engineParameter);
        }
    }

    @Override
    public Response setEngineConfiguration(EngineParameter engineParameter) {
        LOG.debug("Set engine configuration: {}", (Object)engineParameter);
        try {
            String engineName = engineParameter.getEngineName();
            Optional<EngineFactory> factory = this.engineFactories.stream().filter(engineFactory -> engineName.equals(engineFactory.getName())).findFirst();
            if (factory.isPresent()) {
                switch (engineName) {
                    case "dbscan": {
                        return this.configureAndStoreDBScan(engineParameter, this.driver, (DBScanEngineFactory)factory.get().getEngineFactory());
                    }
                    case "deeplearning": {
                        return this.configureAndStoreDeeplearning(engineParameter, this.driver, (DeepLearningEngineFactory)factory.get().getEngineFactory());
                    }
                }
                return this.configureAndStoreCluster(this.driver, (ClusterEngineFactory)factory.get().getEngineFactory());
            }
            return Response.serverError().entity((Object)"No Engine found !!").build();
        }
        catch (Exception e) {
            return ALECRestUtils.somethingWentWrong(e);
        }
    }

    @Override
    public Response getEngineConfiguration() {
        LOG.debug("Get engine configuration");
        try {
            Optional engineConfiguration = this.kvStore.get(KeyEnum.ENGINE.toString(), "ALEC_CONFIG");
            if (engineConfiguration.isPresent()) {
                return Response.ok().entity(this.objectMapper.readValue((String)engineConfiguration.get(), EngineParameter.class)).build();
            }
            return Response.noContent().build();
        }
        catch (JsonProcessingException e) {
            return ALECRestUtils.somethingWentWrong(e);
        }
    }

    private Response storeEngineParameter(EngineParameter engineParameter) throws JsonProcessingException {
        CompletableFuture future = this.kvStore.putAsync(KeyEnum.ENGINE.toString(), (Object)this.objectMapper.writeValueAsString((Object)engineParameter), "ALEC_CONFIG");
        return Response.ok(future.join()).build();
    }

    private Response configureAndStoreCluster(Driver driver, ClusterEngineFactory clusterEngineFactory) {
        driver.setEngineFactory((EngineFactory)clusterEngineFactory);
        Response response = this.driverInit(driver);
        if (response != null) {
            return response;
        }
        try {
            return this.storeEngineParameter(EngineParameterImpl.newBuilder().engineName(clusterEngineFactory.getName()).build());
        }
        catch (JsonProcessingException e) {
            return ALECRestUtils.somethingWentWrong(e);
        }
    }

    private Response configureAndStoreDBScan(EngineParameter engineParameter, Driver driver, DBScanEngineFactory dbScanEngineFactory) {
        dbScanEngineFactory.setAlpha(engineParameter.getAlpha().doubleValue());
        dbScanEngineFactory.setBeta(engineParameter.getBeta().doubleValue());
        dbScanEngineFactory.setEpsilon(engineParameter.getEpsilon().doubleValue());
        dbScanEngineFactory.setDistanceMeasureFactoryName(engineParameter.getDistanceMeasureName());
        driver.setEngineFactory((EngineFactory)dbScanEngineFactory);
        Response response = this.driverInit(driver);
        if (response != null) {
            return response;
        }
        try {
            return this.storeEngineParameter(EngineParameterImpl.newBuilder().alpha(dbScanEngineFactory.getAlpha()).beta(dbScanEngineFactory.getBeta()).epsilon(dbScanEngineFactory.getEpsilon()).distanceMeasureName(dbScanEngineFactory.getDistanceMeasureFactoryName()).engineName(dbScanEngineFactory.getName()).build());
        }
        catch (JsonProcessingException e) {
            return ALECRestUtils.somethingWentWrong(e);
        }
    }

    private Response configureAndStoreDeeplearning(EngineParameter engineParameter, Driver driver, DeepLearningEngineFactory deepLearningEngineFactory) {
        String token = engineParameter.getToken();
        String remoteUri = engineParameter.getRemoteUri();
        if (token != null && !token.isEmpty() && remoteUri != null && !remoteUri.isEmpty()) {
            deepLearningEngineFactory.setUri(remoteUri);
            deepLearningEngineFactory.setToken(token);
            deepLearningEngineFactory.setRemote(true);
        } else {
            deepLearningEngineFactory.setUri("");
            deepLearningEngineFactory.setToken("");
            deepLearningEngineFactory.setRemote(false);
        }
        driver.setEngineFactory((EngineFactory)deepLearningEngineFactory);
        Response response = this.driverInit(driver);
        if (response != null) {
            return response;
        }
        try {
            return this.storeEngineParameter(EngineParameterImpl.newBuilder().engineName(deepLearningEngineFactory.getName()).remoteUri(deepLearningEngineFactory.getUri()).token(deepLearningEngineFactory.getToken()).remote(deepLearningEngineFactory.isRemote()).build());
        }
        catch (JsonProcessingException e) {
            return ALECRestUtils.somethingWentWrong(e);
        }
    }

    private Response driverInit(Driver driver) {
        driver.destroy();
        CompletableFuture future = driver.initAsync();
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOG.error("Engine creation failed", e.getCause());
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.error("Engine creation failed", e.getCause());
            return ALECRestUtils.somethingWentWrong(e);
        }
        return null;
    }
}

