/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.opennms.alec.data.Agreement;
import org.opennms.alec.data.AlarmSet;
import org.opennms.alec.data.CreateSituationPayload;
import org.opennms.alec.data.KeyEnum;
import org.opennms.alec.data.SituationStatus;
import org.opennms.alec.data.SituationStatusImpl;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.AlarmDatasource;
import org.opennms.alec.datasource.api.Severity;
import org.opennms.alec.datasource.api.Situation;
import org.opennms.alec.datasource.api.SituationDatasource;
import org.opennms.alec.datasource.api.Status;
import org.opennms.alec.datasource.common.ImmutableSituation;
import org.opennms.alec.grpc.GrpcConnectionConfig;
import org.opennms.alec.grpc.SituationClient;
import org.opennms.alec.rest.ALECRestUtils;
import org.opennms.alec.rest.SituationRest;
import org.opennms.integration.api.v1.distributed.KeyValueStore;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SituationRestImpl
implements SituationRest {
    private static final Logger LOG = LoggerFactory.getLogger(SituationRestImpl.class);
    public static final String SITUATION_NOT_FOUND = "Situation {0} not found";
    private final ObjectMapper objectMapper;
    private final KeyValueStore<String> kvStore;
    private final SituationDatasource situationDatasource;
    private final GrpcConnectionConfig grpcConnectionConfig;
    private SituationClient client;
    private final AlarmDatasource alarmDatasource;
    private final RuntimeInfo runtimeInfo;

    public SituationRestImpl(KeyValueStore<String> kvStore, SituationDatasource situationDatasource, AlarmDatasource alarmDatasource, RuntimeInfo runtimeInfo, GrpcConnectionConfig grpcConnectionConfig) {
        this.kvStore = Objects.requireNonNull(kvStore);
        this.situationDatasource = Objects.requireNonNull(situationDatasource);
        this.alarmDatasource = Objects.requireNonNull(alarmDatasource);
        this.runtimeInfo = Objects.requireNonNull(runtimeInfo);
        this.objectMapper = new ObjectMapper();
        this.grpcConnectionConfig = grpcConnectionConfig;
        this.client = new SituationClient(this.canWeStore(kvStore), this.grpcConnectionConfig);
    }

    protected SituationRestImpl(KeyValueStore<String> kvStore, SituationDatasource situationDatasource, AlarmDatasource alarmDatasource, RuntimeInfo runtimeInfo, GrpcConnectionConfig grpcConnectionConfig, SituationClient situationClient) {
        this.kvStore = Objects.requireNonNull(kvStore);
        this.situationDatasource = Objects.requireNonNull(situationDatasource);
        this.alarmDatasource = Objects.requireNonNull(alarmDatasource);
        this.runtimeInfo = Objects.requireNonNull(runtimeInfo);
        this.objectMapper = new ObjectMapper();
        this.grpcConnectionConfig = grpcConnectionConfig;
        this.client = situationClient;
    }

    @Override
    public Response rejected(String situationId, String feedback) {
        try {
            Optional situationOptional = this.situationDatasource.getSituation(Integer.parseInt(situationId));
            if (situationOptional.isPresent()) {
                Situation situation = (Situation)situationOptional.get();
                if (Status.REJECTED.equals((Object)situation.getStatus())) {
                    LOG.debug("Situation {} already rejected", (Object)situationId);
                    return Response.accepted((Object)MessageFormat.format("Situation {0} already rejected", situationId)).build();
                }
                feedback = String.format("reject situation [%s]", situationId);
                this.client.sendSituation((Situation)ImmutableSituation.newBuilderFrom((Situation)situation).setStatus(Status.REJECTED).setAlarms(situation.getAlarms()).addFeedback(feedback).build(), this.runtimeInfo.getSystemId());
                this.kvStoreSituationsByStatus();
                this.situationDatasource.forwardSituation((Situation)ImmutableSituation.newBuilderFrom((Situation)situation).setStatus(Status.REJECTED).setAlarms(Collections.emptySet()).setSeverity(Severity.NORMAL).addFeedback(feedback).build());
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)MessageFormat.format(SITUATION_NOT_FOUND, situationId)).build();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ALECRestUtils.somethingWentWrong(e);
        }
        catch (Exception e) {
            return ALECRestUtils.somethingWentWrong(e);
        }
    }

    @Override
    public Response accepted(String situationId) {
        try {
            Optional situationOptional = this.situationDatasource.getSituation(Integer.parseInt(situationId));
            if (situationOptional.isPresent()) {
                Situation situation = (Situation)situationOptional.get();
                if (Status.ACCEPTED.equals((Object)situation.getStatus())) {
                    LOG.debug("Situation {} already accepted", (Object)situationId);
                    return Response.accepted((Object)MessageFormat.format("Situation {0} already accepted", situationId)).build();
                }
                return this.forwardAndStoreSituation((Situation)ImmutableSituation.newBuilderFrom((Situation)situation).setStatus(Status.ACCEPTED).build(), situation.getAlarms());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ALECRestUtils.somethingWentWrong(e);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)MessageFormat.format(SITUATION_NOT_FOUND, situationId)).build();
    }

    @Override
    public Response getSituationStatusList() {
        try {
            ArrayList situationStatusList = new ArrayList();
            this.situationDatasource.getSituations().forEach(o -> situationStatusList.add(SituationStatusImpl.newBuilder().id(String.valueOf(o.getLongId())).status(o.getStatus()).build()));
            List sorted = situationStatusList.stream().sorted(Comparator.comparing(SituationStatus::getStatus)).collect(Collectors.toList());
            return Response.ok(sorted).build();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ALECRestUtils.somethingWentWrong(e);
        }
    }

    @Override
    public Response getSituationList() {
        try {
            List situations = this.situationDatasource.getSituations();
            return Response.ok((Object)situations).build();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ALECRestUtils.somethingWentWrong(e);
        }
    }

    @Override
    public Response addAlarm(AlarmSet alarm) {
        try {
            Optional situationOptional = this.situationDatasource.getSituation(Integer.parseInt(alarm.getSituationId()));
            if (situationOptional.isPresent()) {
                Situation oldSituation = (Situation)situationOptional.get();
                Set<Alarm> alarmSet = this.getAlarmSetToAdd(alarm.getAlarmIdList());
                alarmSet.addAll(oldSituation.getAlarms());
                if (oldSituation.getAlarms().equals(alarmSet)) {
                    return ALECRestUtils.noContent();
                }
                String feedback = String.format("add alarm(s) [%s] to situation [%s]", alarm.getAlarmIdList(), alarm.getSituationId());
                return this.forwardAndStoreSituation((Situation)ImmutableSituation.newBuilderFrom((Situation)oldSituation).addFeedback(feedback).build(), alarmSet);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ALECRestUtils.somethingWentWrong(e);
        }
        return ALECRestUtils.noContent();
    }

    @Override
    public Response removeAlarm(AlarmSet alarm) {
        String situationId = alarm.getSituationId();
        try {
            Optional situationOptional = this.situationDatasource.getSituation(Integer.parseInt(situationId));
            if (situationOptional.isPresent()) {
                Situation oldSituation = (Situation)situationOptional.get();
                Set<Alarm> alarmSet = oldSituation.getAlarms().stream().filter(a -> !alarm.getAlarmIdList().contains(String.valueOf(a.getLongId()))).collect(Collectors.toUnmodifiableSet());
                if (oldSituation.getAlarms().equals(alarmSet)) {
                    return ALECRestUtils.noContent();
                }
                String feedback = String.format("remove alarm(s) [%s] to situation [%s]", alarm.getAlarmIdList(), situationId);
                return this.forwardAndStoreSituation((Situation)ImmutableSituation.newBuilderFrom((Situation)oldSituation).addFeedback(feedback).setStatus(Status.REMOVED_ALARM).build(), alarmSet);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ALECRestUtils.somethingWentWrong(e);
        }
        return ALECRestUtils.noContent();
    }

    @Override
    public Response createSituation(CreateSituationPayload createSituationPayload) {
        Set<Alarm> alarmSetToAdd;
        try {
            alarmSetToAdd = this.getAlarmSetToAdd(createSituationPayload.getAlarmIdList());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ALECRestUtils.somethingWentWrong(e);
        }
        String situationId = UUID.randomUUID().toString();
        Severity maxSeverity = Severity.fromValue((int)alarmSetToAdd.stream().mapToInt(a -> a.getSeverity() != null ? a.getSeverity().getValue() : Severity.INDETERMINATE.getValue()).max().orElseGet(() -> ((Severity)Severity.INDETERMINATE).getValue()));
        ImmutableSituation situation = ImmutableSituation.newBuilder().setId(situationId).setCreationTime(System.currentTimeMillis()).setLastTime(Long.valueOf(System.currentTimeMillis())).setAlarms(alarmSetToAdd).setDiagnosticText(createSituationPayload.getDiagnosticText()).setDescription(createSituationPayload.getDescription()).setSeverity(maxSeverity).setEngineParameter("user created").addFeedback(createSituationPayload.getFeedback()).setStatus(Status.USER_CREATED).build();
        if (situation.getAlarms().size() >= 2) {
            this.forwardAndStoreSituation((Situation)situation, alarmSetToAdd);
            return Response.ok().build();
        }
        return ALECRestUtils.noContent();
    }

    private Set<Alarm> getAlarmSetToAdd(List<String> alarmIdList) throws InterruptedException {
        HashSet<Alarm> alarms = new HashSet<Alarm>();
        for (String id : alarmIdList) {
            Optional alarm = this.alarmDatasource.getAlarm(Integer.parseInt(id));
            if (!alarm.isPresent() || !this.alarmIsNotInAnotherSituation(((Alarm)alarm.get()).getReductionKey())) continue;
            alarms.add((Alarm)alarm.get());
        }
        return alarms;
    }

    private boolean alarmIsNotInAnotherSituation(String reductionKey) throws InterruptedException {
        for (Situation situation : this.situationDatasource.getSituations()) {
            for (Alarm alarm : situation.getAlarms()) {
                if (!reductionKey.equals(alarm.getReductionKey())) continue;
                LOG.debug("Alarm {} is in another situation", (Object)alarm.getReductionKey());
                return false;
            }
        }
        return true;
    }

    private Response forwardAndStoreSituation(Situation oldSituation, Set<Alarm> alarms) {
        try {
            ImmutableSituation newSituation = ImmutableSituation.newBuilderFrom((Situation)oldSituation).setAlarms(alarms).build();
            this.situationDatasource.forwardSituation((Situation)newSituation);
            this.client.sendSituation((Situation)newSituation, this.runtimeInfo.getSystemId());
            this.kvStoreSituationsByStatus();
            return Response.ok().build();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ALECRestUtils.somethingWentWrong(e);
        }
        catch (Exception e) {
            return ALECRestUtils.somethingWentWrong(e);
        }
    }

    private void kvStoreSituationsByStatus() throws JsonProcessingException, InterruptedException {
        List acceptedSituations = this.situationDatasource.getSituations().stream().filter(s -> Status.ACCEPTED.equals((Object)s.getStatus())).collect(Collectors.toList());
        List rejectedSituations = this.situationDatasource.getSituations().stream().filter(s -> Status.REJECTED.equals((Object)s.getStatus())).collect(Collectors.toList());
        this.kvStore.put(KeyEnum.ACCEPTED_SITUATION.toString(), (Object)this.objectMapper.writeValueAsString(acceptedSituations), "ALEC_CONFIG");
        this.kvStore.put(KeyEnum.REJECTED_SITUATION.toString(), (Object)this.objectMapper.writeValueAsString(rejectedSituations), "ALEC_CONFIG");
    }

    private boolean canWeStore(KeyValueStore<String> kvStore) {
        boolean doStore;
        Optional agreementConfiguration = kvStore.get(KeyEnum.AGREEMENT.toString(), "ALEC_CONFIG");
        if (agreementConfiguration.isPresent()) {
            try {
                doStore = ((Agreement)this.objectMapper.readValue((String)agreementConfiguration.get(), Agreement.class)).isAgreed();
            }
            catch (JsonProcessingException e) {
                doStore = false;
            }
        } else {
            doStore = false;
        }
        return doStore;
    }

    @Override
    public void updateAgreement(boolean doStore) {
        this.client.createChannel(doStore);
    }

    public void destroy() {
        this.client.destroy();
    }
}

