/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.processor.api;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.Situation;
import org.opennms.alec.datasource.api.SituationHandler;
import org.opennms.alec.processor.api.SituationProcessor;

public class SituationConfirmer
implements SituationHandler {
    private final SituationProcessor situationProcessor;

    private SituationConfirmer(SituationProcessor situationProcessor) {
        this.situationProcessor = situationProcessor;
    }

    public static SituationConfirmer newInstance(SituationProcessor situationProcessor) {
        return new SituationConfirmer(situationProcessor);
    }

    public void onSituation(Situation situation) {
        Set reductionKeysInAlarm = Objects.requireNonNull(situation).getAlarms().stream().map(Alarm::getId).collect(Collectors.toSet());
        this.situationProcessor.confirm(Collections.unmodifiableSet(reductionKeysInAlarm));
    }
}

