/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.processor.redundant;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opennms.alec.datasource.api.Alarm;
import org.opennms.alec.datasource.api.Situation;
import org.opennms.alec.datasource.api.SituationDatasource;
import org.opennms.alec.processor.api.SituationProcessor;
import org.opennms.alec.processor.redundant.SynchronizedExpiringLinkedHashMap;
import org.opennms.integration.api.v1.coordination.DomainManager;
import org.opennms.integration.api.v1.coordination.DomainManagerFactory;
import org.opennms.integration.api.v1.coordination.Role;
import org.opennms.integration.api.v1.coordination.RoleChangeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveStandbySituationProcessor
implements SituationProcessor,
RoleChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveStandbySituationProcessor.class);
    static final String ALEC_DOMAIN = "alec";
    private static final String ALEC_SERVICE_ID = "alec.driver";
    private final DomainManager domainManager;
    private final SituationDatasource situationDatasource;
    private Role currentRole = Role.UNKNOWN;
    private final Map<Set<String>, Situation> unconfirmedSituations = SynchronizedExpiringLinkedHashMap.newInstance(1L, TimeUnit.MINUTES);

    private ActiveStandbySituationProcessor(SituationDatasource situationDatasource, DomainManagerFactory domainManagerFactory) {
        this.situationDatasource = Objects.requireNonNull(situationDatasource);
        this.domainManager = Objects.requireNonNull(domainManagerFactory).getManagerForDomain(ALEC_DOMAIN);
    }

    static ActiveStandbySituationProcessor newInstance(SituationDatasource situationDatasource, DomainManagerFactory domainManagerFactory) {
        ActiveStandbySituationProcessor instance = new ActiveStandbySituationProcessor(situationDatasource, domainManagerFactory);
        LOG.debug("Registering service {} for domain {}", (Object)ALEC_SERVICE_ID, (Object)ALEC_DOMAIN);
        instance.domainManager.register(ALEC_SERVICE_ID, (RoleChangeHandler)instance);
        return instance;
    }

    private synchronized boolean isActive() {
        return this.currentRole == Role.ACTIVE;
    }

    private void storeSituation(Situation situation) {
        LOG.debug("Storing situation {}", (Object)situation);
        Set reductionKeys = situation.getAlarms().stream().map(Alarm::getId).collect(Collectors.toSet());
        this.unconfirmedSituations.put(Collections.unmodifiableSet(reductionKeys), situation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void catchupSituations() {
        Map<Set<String>, Situation> map = this.unconfirmedSituations;
        synchronized (map) {
            LOG.debug("Catching up stored situations");
            Iterator<Map.Entry<Set<String>, Situation>> iter = this.unconfirmedSituations.entrySet().iterator();
            while (iter.hasNext() && this.isActive()) {
                Situation situation = iter.next().getValue();
                LOG.debug("Catching up situation {}", (Object)situation);
                this.forwardSituation(situation);
                iter.remove();
            }
        }
    }

    private void forwardSituation(Situation situation) {
        try {
            LOG.debug("Forwarding situation: {}", (Object)situation);
            this.situationDatasource.forwardSituation(situation);
            LOG.debug("Successfully forwarded situation.");
        }
        catch (Exception e) {
            LOG.error("An error occurred while forwarding situation: {}. The situation will be lost.", (Object)situation, (Object)e);
        }
    }

    Role getCurrentRole() {
        return this.currentRole;
    }

    void destroy() {
        LOG.debug("Deregistering service {}", (Object)ALEC_SERVICE_ID);
        this.domainManager.deregister(ALEC_SERVICE_ID);
    }

    Map<Set<String>, Situation> getUnconfirmedSituations() {
        return Collections.unmodifiableMap(new LinkedHashMap<Set<String>, Situation>(this.unconfirmedSituations));
    }

    public void accept(Situation situation) {
        Objects.requireNonNull(situation);
        if (this.isActive()) {
            this.forwardSituation(situation);
        } else {
            this.storeSituation(situation);
        }
    }

    public void confirm(Set<String> reductionKeysInAlarm) {
        LOG.debug("Confirming alarm with key {}", reductionKeysInAlarm);
        this.unconfirmedSituations.remove(reductionKeysInAlarm);
    }

    public synchronized void handleRoleChange(Role role, String domain) {
        LOG.debug("Became {} for domain {}", (Object)role, (Object)domain);
        this.currentRole = role;
        if (this.isActive()) {
            CompletableFuture.runAsync(this::catchupSituations);
        }
    }
}

