/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.processor.redundant;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;

public class SynchronizedExpiringLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private final long timeToLiveMillis;
    private final BlockingQueue<DelayedKey> expiryQueue = new DelayQueue<DelayedKey>();
    private final Map<K, V> wrapper;
    private final Thread expiringThread = new Thread(this::expireEntries);

    private SynchronizedExpiringLinkedHashMap(long timeToLive, TimeUnit timeUnit) {
        this.timeToLiveMillis = timeUnit.toMillis(timeToLive);
        this.wrapper = Collections.synchronizedMap(this);
    }

    static <K, V> Map<K, V> newInstance(long timeToLive, TimeUnit timeUnit) {
        SynchronizedExpiringLinkedHashMap<K, V> instance = new SynchronizedExpiringLinkedHashMap<K, V>(timeToLive, timeUnit);
        instance.expiringThread.start();
        return instance.wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void expireEntries() {
        while (true) {
            try {
                while (true) {
                    DelayedKey delayedKey = this.expiryQueue.take();
                    Map<K, V> map = this.wrapper;
                    synchronized (map) {
                        this.remove(delayedKey.getKey());
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public void clear() {
        this.expiryQueue.clear();
        super.clear();
    }

    @Override
    public V put(K key, V value) {
        this.expiryQueue.offer(new DelayedKey(this.timeToLiveMillis, key));
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    private class DelayedKey
    implements Delayed {
        private final long delayTime;
        private final long startTime;
        private final K key;

        DelayedKey(long delayTime, K key) {
            this.delayTime = delayTime;
            this.startTime = System.currentTimeMillis();
            this.key = key;
        }

        K getKey() {
            return this.key;
        }

        private long getRemainingDelay() {
            return this.startTime + this.delayTime - System.currentTimeMillis();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.getRemainingDelay(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.getRemainingDelay(), o.getDelay(TimeUnit.MILLISECONDS));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DelayedKey that = (DelayedKey)o;
            return this.delayTime == that.delayTime && this.startTime == that.startTime && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.delayTime, this.startTime, this.key);
        }
    }
}

