/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.alec.processor.standalone;

import java.util.Objects;
import org.opennms.alec.datasource.api.Situation;
import org.opennms.alec.datasource.api.SituationDatasource;
import org.opennms.alec.processor.api.SituationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneSituationProcessor
implements SituationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneSituationProcessor.class);
    private final SituationDatasource situationDatasource;

    StandaloneSituationProcessor(SituationDatasource situationDatasource) {
        this.situationDatasource = Objects.requireNonNull(situationDatasource);
    }

    public void accept(Situation situation) {
        Objects.requireNonNull(situation);
        try {
            LOG.debug("Forwarding situation: {}", (Object)situation);
            this.situationDatasource.forwardSituation(situation);
            LOG.debug("Successfully forwarded situation.");
        }
        catch (Exception e) {
            LOG.error("An error occurred while forwarding situation: {}. The situation will be lost.", (Object)situation, (Object)e);
        }
    }
}

