/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable;

import de.vandermeer.asciitable.AT_Cell;
import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.skb.interfaces.document.TableRowType;
import de.vandermeer.skb.interfaces.transformers.Object_To_StrBuilder;
import de.vandermeer.skb.interfaces.transformers.String_To_ConditionalBreak;
import java.util.LinkedList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class CWC_LongestLine
implements AT_ColumnWidthCalculator {
    private int[] minWidths = new int[0];
    private int[] maxWidths = new int[0];

    public CWC_LongestLine add(int minWidth, int maxWidth) {
        this.minWidths = ArrayUtils.add((int[])this.minWidths, (int)minWidth);
        this.maxWidths = ArrayUtils.add((int[])this.maxWidths, (int)maxWidth);
        return this;
    }

    @Override
    public int[] calculateColumnWidths(LinkedList<AT_Row> rows, int colNumbers, int tableWidth) {
        Validate.notNull(rows);
        int[] resultWidths = new int[colNumbers];
        System.arraycopy(this.minWidths, 0, resultWidths, 0, this.minWidths.length > colNumbers ? colNumbers : this.minWidths.length);
        for (AT_Row row : rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            LinkedList<AT_Cell> cells = row.getCells();
            for (int i = 0; i < cells.size(); ++i) {
                String[] lines;
                if (cells.get(i).getContent() == null) continue;
                for (String line : lines = String_To_ConditionalBreak.convert(Object_To_StrBuilder.convert(cells.get(i).getContent()).toString())) {
                    int lineWidth = line.length() + cells.get(i).getContext().getPaddingLeft() + cells.get(i).getContext().getPaddingRight();
                    if (lineWidth <= resultWidths[i]) continue;
                    int maxWidth = this.maxWidths.length > i ? this.maxWidths[i] : 0;
                    resultWidths[i] = maxWidth < 1 || lineWidth < maxWidth ? lineWidth : maxWidth;
                }
            }
        }
        return resultWidths;
    }
}

