/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciithemes;

import de.vandermeer.asciithemes.TA_Corner;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public interface TA_Corner_Strings
extends TA_Corner {
    public String getTopLeftString();

    public String getTopRightString();

    public String getBottomLeftString();

    public String getBottomRightString();

    @Override
    default public StrBuilder getCorner(int mode, StrBuilder builder) {
        StrBuilder ret = builder == null ? new StrBuilder() : builder;
        switch (mode) {
            case 1: {
                return ret.append(this.getTopLeftString());
            }
            case 2: {
                return ret.append(this.getTopRightString());
            }
            case 3: {
                return ret.append(this.getBottomLeftString());
            }
            case 4: {
                return ret.append(this.getBottomRightString());
            }
        }
        return ret;
    }

    @Override
    default public StrBuilder toDoc() {
        StrBuilder ret = new StrBuilder(10).append(this.getTopLeftString()).append(' ').append(this.getTopRightString()).appendNewLine().appendNewLine().append(this.getBottomLeftString()).append(' ').append(this.getBottomRightString());
        return ret;
    }

    public static TA_Corner_Strings create(final String topleft, final String topright, final String bottomleft, final String bottomright, final String description) {
        Validate.notNull((Object)topleft);
        Validate.notNull((Object)topright);
        Validate.notNull((Object)bottomleft);
        Validate.notNull((Object)bottomright);
        Validate.notBlank((CharSequence)description);
        return new TA_Corner_Strings(){

            @Override
            public String getTopRightString() {
                return topright;
            }

            @Override
            public String getTopLeftString() {
                return topleft;
            }

            @Override
            public String getBottomRightString() {
                return bottomright;
            }

            @Override
            public String getBottomLeftString() {
                return bottomleft;
            }

            @Override
            public String getDescription() {
                return description;
            }
        };
    }
}

