/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciithemes.u8;

import de.vandermeer.asciithemes.TA_Numbering;
import de.vandermeer.skb.interfaces.transformers.Integer_To_RomanLiteral;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public interface U8_NumberingSchemes {
    public static TA_Numbering AlphaCircledLatin() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 27 ? 1 : 0) != 0, (String)("numbering supported 0<number<27 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 9397));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 26;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Circled Latin Capital (upper case) characters '\u24b6-\u24cf'";
            }
        };
    }

    public static TA_Numbering alphaCircledLatin() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 27 ? 1 : 0) != 0, (String)("numbering supported 0<number<27 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 9423));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 26;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Circled Latin Capital (lower case) characters '\u24d0-\u24e9'";
            }
        };
    }

    public static TA_Numbering alphaParenthesizedLatinSmallLetter() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 27 ? 1 : 0) != 0, (String)("numbering supported 0<number<27 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 9371));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 26;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Parenthesized Latin Small Letter (lower case) characters '\u249c-\u24b5'";
            }
        };
    }

    public static TA_Numbering AlphaFullwidthLatinCapitalLetter() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 27 ? 1 : 0) != 0, (String)("numbering supported 0<number<27 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 65312));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 26;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Fullwidth Latin Capital Letter (upper case) characters '\uff21-\uff3a'";
            }
        };
    }

    public static TA_Numbering alphaFullwidthLatinSmallLetter() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 27 ? 1 : 0) != 0, (String)("numbering supported 0<number<27 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 65344));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 26;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Fullwidth Latin Small Letter (lower case) characters '\uff41-\uff5a'";
            }
        };
    }

    public static TA_Numbering numberCircledDigit() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 21 ? 1 : 0) != 0, (String)("numbering supported 0<number<21 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 9311));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 20;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Circled Digit/Number characters '\u2460-\u2473'";
            }
        };
    }

    public static TA_Numbering numberDoubleCircledDigit() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 11 ? 1 : 0) != 0, (String)("numbering supported 0<number<11 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 9460));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 10;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Double Circled Digit/Number characters '\u24f5-\u24fe'";
            }
        };
    }

    public static TA_Numbering numberDingbatNegativeCircledDigit() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 11 ? 1 : 0) != 0, (String)("numbering supported 0<number<11 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 10101));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 10;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Dingbat Negative Circled Digit characters '\u2776-\u277f'";
            }
        };
    }

    public static TA_Numbering numberDingbatNegativeSanserifCircledDigit() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 11 ? 1 : 0) != 0, (String)("numbering supported 0<number<11 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 10121));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 10;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Dingbat Negative Sanserif Circled Digit characters '\u278a-\u2793'";
            }
        };
    }

    public static TA_Numbering numberDingbatSanserifCircledDigit() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 11 ? 1 : 0) != 0, (String)("numbering supported 0<number<11 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 10111));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 10;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Dingbat Sanserif Circled Digit characters '\u2780-\u2789'";
            }
        };
    }

    public static TA_Numbering numberSuperscript() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 10 ? 1 : 0) != 0, (String)("numbering supported 0<number<10 - number was: " + number), (Object[])new Object[0]);
                if (number == 1) {
                    return new String(Character.toChars(number + 184));
                }
                if (number > 3) {
                    return new String(Character.toChars(number + 8304));
                }
                return new String(Character.toChars(number + 176));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 9;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Superscript characters '\u00b9-\u2079'";
            }
        };
    }

    public static TA_Numbering numberSubscript() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 10 ? 1 : 0) != 0, (String)("numbering supported 0<number<10 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 8320));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 9;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Subscript characters '\u2081-\u2089'";
            }
        };
    }

    public static TA_Numbering numberFullStop() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 21 ? 1 : 0) != 0, (String)("numbering supported 0<number<21 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 9351));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 20;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Full Stop characters '\u2488-\u249b'";
            }
        };
    }

    public static TA_Numbering numberParenthesized() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 21 ? 1 : 0) != 0, (String)("numbering supported 0<number<21 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 9331));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 20;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Parenthesized Digit/Number characters '\u2474-\u2487'";
            }
        };
    }

    public static TA_Numbering numberFullwidth() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 10 ? 1 : 0) != 0, (String)("numbering supported 0<number<10 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 65296));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 9;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using UTF Fullwidth characters '\uff11-\uff19'";
            }
        };
    }

    public static TA_Numbering RomanNumberForms() {
        return new TA_Numbering(){
            String[] from = new String[]{"M", "D", "C", "L", "XII", "XI", "X", "VIII", "VII", "VI", "V", "III", "II", "I"};
            String[] to = new String[]{"\u216f", "\u216e", "\u216d", "\u216c", "\u216b", "\u216a", "\u2169", "\u2167", "\u2166", "\u2165", "\u2164", "\u2162", "\u2161", "\u2160"};

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 4001 ? 1 : 0) != 0, (String)("numbering supported 0<number<4001 - number was: " + number), (Object[])new Object[0]);
                String literal = Integer_To_RomanLiteral.convert(number);
                literal = literal.replace("IV", "\u2163");
                literal = literal.replace("IX", "\u2168");
                return StringUtils.replaceEach((String)literal, (String[])this.from, (String[])this.to);
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 4000;
            }

            @Override
            public String getDescription() {
                return "Numbering scheme for Roman number literals using upper case UTF-8 Number Forms upper case characters.";
            }
        };
    }

    public static TA_Numbering romanNumberForms() {
        return new TA_Numbering(){
            String[] from = new String[]{"M", "D", "C", "L", "XIII", "XII", "XI", "X", "VIII", "VII", "VI", "V", "III", "II", "I"};
            String[] to = new String[]{"\u217f", "\u217e", "\u217d", "\u217c", "\u2179\u2172", "\u217b", "\u217a", "\u2179", "\u2177", "\u2176", "\u2175", "\u2174", "\u2172", "\u2171", "\u2170"};

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 4001 ? 1 : 0) != 0, (String)("numbering supported 0<number<4001 - number was: " + number), (Object[])new Object[0]);
                String literal = Integer_To_RomanLiteral.convert(number);
                literal = literal.replace("IV", "\u2173");
                literal = literal.replace("IX", "\u2178");
                return StringUtils.replaceEach((String)literal, (String[])this.from, (String[])this.to);
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 4000;
            }

            @Override
            public String getDescription() {
                return "Numbering scheme for Roman number literals using lower case UTF-8 Number Forms lower case characters.";
            }
        };
    }

    public static TA_Numbering RomanCircledLatinCapital() {
        return new TA_Numbering(){
            String[] from = new String[]{"M", "D", "C", "L", "X", "V", "I"};
            String[] to = new String[]{"\u24c2", "\u24b9", "\u24b8", "\u24c1", "\u24cd", "\u24cb", "\u24be"};

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 4001 ? 1 : 0) != 0, (String)("numbering supported 0<number<4001 - number was: " + number), (Object[])new Object[0]);
                return StringUtils.replaceEach((String)Integer_To_RomanLiteral.convert(number), (String[])this.from, (String[])this.to);
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 4000;
            }

            @Override
            public String getDescription() {
                return "Numbering scheme for Roman number literals using upper case UTF-8 Circled Latin Capital (upper case) characters.";
            }
        };
    }

    public static TA_Numbering romanCircledLatinSmall() {
        return new TA_Numbering(){
            String[] from = new String[]{"M", "D", "C", "L", "X", "V", "I"};
            String[] to = new String[]{"\u24dc", "\u24d3", "\u24d2", "\u24db", "\u24e7", "\u24e5", "\u24d8"};

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 4001 ? 1 : 0) != 0, (String)("numbering supported 0<number<4001 - number was: " + number), (Object[])new Object[0]);
                return StringUtils.replaceEach((String)Integer_To_RomanLiteral.convert(number), (String[])this.from, (String[])this.to);
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 4000;
            }

            @Override
            public String getDescription() {
                return "Numbering scheme for Roman number literals using lower case UTF-8 Circled Latin Small (lower case) characters.";
            }
        };
    }
}

