/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.messagesets;

import de.vandermeer.skb.interfaces.messagesets.IsMessageSet;
import de.vandermeer.skb.interfaces.render.DoesRender;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.text.StrBuilder;

public interface IsInfoSet<M>
extends IsMessageSet {
    @Override
    default public boolean isInfoSet() {
        return true;
    }

    default public void clearInfoMessages() {
        this.getInfoMessages().clear();
    }

    public Set<M> getInfoMessages();

    default public void addInfo(M info) {
        this.getInfoMessages().add(info);
    }

    default public void addAllInfos(Collection<M> infos) {
        this.getInfoMessages().addAll(infos);
    }

    default public boolean hasInformation() {
        return this.getInfoMessages().size() != 0;
    }

    @Override
    default public String render() {
        StrBuilder ret = new StrBuilder(100);
        for (M m : this.getInfoMessages()) {
            if (m instanceof DoesRender) {
                ret.append(((DoesRender)m).render());
            } else {
                ret.append(m);
            }
            ret.appendNewLine();
        }
        return ret.toString();
    }

    public static <M> IsInfoSet<M> create() {
        return new IsInfoSet<M>(){
            final Set<M> infoSet = new LinkedHashSet();

            @Override
            public Set<M> getInfoMessages() {
                return this.infoSet;
            }
        };
    }
}

