/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable;

import de.vandermeer.asciitable.AT_Cell;
import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AT_Context;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.asciitable.AsciiTableException;
import de.vandermeer.asciitable.CWC_AbsoluteEven;
import de.vandermeer.skb.interfaces.document.IsTableRenderer;
import de.vandermeer.skb.interfaces.render.DoesRenderToWidth;
import de.vandermeer.skb.interfaces.render.RendersToClusterWidth;
import de.vandermeer.skb.interfaces.strategies.collections.list.ArrayListStrategy;
import de.vandermeer.skb.interfaces.transformers.ClusterElementTransformer;
import de.vandermeer.skb.interfaces.transformers.Object_To_StrBuilder;
import de.vandermeer.skb.interfaces.transformers.StrBuilder_To_String;
import de.vandermeer.skb.interfaces.transformers.arrays2d.Array2D_To_FlipArray;
import de.vandermeer.skb.interfaces.transformers.arrays2d.Array2D_To_NormalizedArray;
import de.vandermeer.skb.interfaces.transformers.textformat.TextFormat;
import de.vandermeer.skb.interfaces.transformers.textformat.Text_To_FormattedText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrTokenizer;
import org.apache.commons.lang3.tuple.Pair;

public interface AT_Renderer
extends IsTableRenderer {
    public static AT_Renderer create() {
        return new AT_Renderer(){
            AT_ColumnWidthCalculator cwc = new CWC_AbsoluteEven();
            String lineSeparator = null;

            @Override
            public AT_ColumnWidthCalculator getCWC() {
                return this.cwc;
            }

            @Override
            public String getLineSeparator() {
                return this.lineSeparator;
            }

            @Override
            public AT_Renderer setCWC(AT_ColumnWidthCalculator cwc) {
                if (cwc != null) {
                    this.cwc = cwc;
                }
                return this;
            }

            @Override
            public AT_Renderer setLineSeparator(String separator) {
                if (!StringUtils.isBlank((CharSequence)separator)) {
                    this.lineSeparator = separator;
                }
                return this;
            }
        };
    }

    default public AT_ColumnWidthCalculator getCWC() {
        return null;
    }

    public String getLineSeparator();

    default public String render(LinkedList<AT_Row> rows, int colNumbers, AT_Context ctx) {
        Validate.notNull(rows);
        Validate.notNull((Object)ctx);
        return this.render(rows, colNumbers, ctx, ctx.getWidth());
    }

    default public String render(LinkedList<AT_Row> rows, int colNumbers, AT_Context ctx, int width) {
        Validate.notNull(rows);
        Validate.notNull((Object)ctx);
        Collection<StrBuilder> coll = this.renderAsCollection(rows, colNumbers, ctx, width);
        String fileSeparator = this.getLineSeparator();
        if (fileSeparator == null) {
            fileSeparator = ctx.getLineSeparator();
        }
        if (fileSeparator == null) {
            fileSeparator = System.lineSeparator();
        }
        return new StrBuilder().appendWithSeparators(coll, fileSeparator).build();
    }

    default public Collection<StrBuilder> renderAsCollection(LinkedList<AT_Row> rows, int colNumbers, AT_Context ctx) {
        Validate.notNull(rows);
        Validate.notNull((Object)ctx);
        return this.renderAsCollection(rows, colNumbers, ctx, ctx.getWidth());
    }

    default public Collection<StrBuilder> renderAsCollection(LinkedList<AT_Row> rows, int colNumbers, AT_Context ctx, int width) {
        int k;
        Validate.notNull(rows);
        Validate.notNull((Object)ctx);
        ArrayList<Object> table = new ArrayList<Object>();
        int[] colWidth = this.getCWC().calculateColumnWidths(rows, colNumbers, ctx.getTextWidth(width));
        block12: for (AT_Row row : rows) {
            int ruleset = 0;
            switch (row.getStyle()) {
                case NORMAL: {
                    ruleset = 256;
                    break;
                }
                case STRONG: {
                    ruleset = 512;
                    break;
                }
                case LIGHT: {
                    ruleset = 2048;
                    break;
                }
                case HEAVY: {
                    ruleset = 1024;
                    break;
                }
                case UNKNOWN: {
                    throw new AsciiTableException("AT_Renderer: cannot render unknown row style", "table row style set to 'unknown'");
                }
                default: {
                    throw new AsciiTableException("AT_Renderer: cannot render unknown row style", "table row style not specified or type not processed");
                }
            }
            switch (row.getType()) {
                case RULE: {
                    table.add(ruleset);
                    continue block12;
                }
                case CONTENT: {
                    String[][] cAr = new String[colNumbers][];
                    LinkedList<AT_Cell> cells = row.getCells();
                    if (cells == null) {
                        throw new AsciiTableException("cannot render table", "row content (cells) was null");
                    }
                    int length = 0;
                    for (int i = 0; i < cells.size(); ++i) {
                        length += colWidth[i];
                        Object content = cells.get(i).getContent();
                        if (content == null) {
                            ++length;
                            continue;
                        }
                        int realWidth = length;
                        length -= cells.get(i).getContext().getPaddingLeft();
                        length -= cells.get(i).getContext().getPaddingRight();
                        if (content instanceof RendersToClusterWidth) {
                            cAr[i] = ((RendersToClusterWidth)content).renderAsArray(length);
                        }
                        if (content instanceof DoesRenderToWidth) {
                            cAr[i] = new StrTokenizer(((DoesRenderToWidth)content).render(length)).setDelimiterChar('\n').setIgnoreEmptyTokens(false).getTokenArray();
                        } else {
                            int k2;
                            String text = Object_To_StrBuilder.convert(content).toString().replaceAll("\\s+", " ");
                            if (cells.get(i).getContext().getTargetTranslator() != null) {
                                if (cells.get(i).getContext().getTargetTranslator().getCombinedTranslator() != null) {
                                    text = cells.get(i).getContext().getTargetTranslator().getCombinedTranslator().translate(text);
                                }
                            } else if (cells.get(i).getContext().getHtmlElementTranslator() != null) {
                                text = cells.get(i).getContext().getHtmlElementTranslator().translateHtmlElements(text);
                            } else if (cells.get(i).getContext().getCharTranslator() != null) {
                                text = cells.get(i).getContext().getCharTranslator().translateCharacters(text);
                            }
                            Collection<StrBuilder> csb = Text_To_FormattedText.create(length, cells.get(i).getContext().getTextAlignment().getMapping(), TextFormat.NONE.getMapping(), null, null, null, 0, 0, null, 0, 0, null).transform(text);
                            for (StrBuilder sb : csb) {
                                sb.insert(0, (Object)new StrBuilder().appendPadding(cells.get(i).getContext().getPaddingLeft(), cells.get(i).getContext().getPaddingLeftChar().charValue()));
                                sb.appendPadding(cells.get(i).getContext().getPaddingRight(), cells.get(i).getContext().getPaddingRightChar().charValue());
                            }
                            for (k2 = 0; k2 < cells.get(i).getContext().getPaddingTop(); ++k2) {
                                ((ArrayList)csb).add(0, new StrBuilder().appendPadding(realWidth, cells.get(i).getContext().getPaddingTopChar().charValue()));
                            }
                            for (k2 = 0; k2 < cells.get(i).getContext().getPaddingBottom(); ++k2) {
                                ((ArrayList)csb).add(new StrBuilder().appendPadding(realWidth, cells.get(i).getContext().getPaddingBottomChar().charValue()));
                            }
                            cAr[i] = ((ArrayList)ClusterElementTransformer.create().transform(csb, StrBuilder_To_String.create(), ArrayListStrategy.create())).toArray(new String[0]);
                        }
                        length = 0;
                    }
                    cAr = Array2D_To_NormalizedArray.create(colNumbers).transform(cAr);
                    cAr = Array2D_To_FlipArray.create().transform(cAr);
                    table.add(Pair.of((Object)ruleset, (Object)cAr));
                    continue block12;
                }
                case UNKNOWN: {
                    throw new AsciiTableException("AT_Renderer: cannot render unknown row type", "table row type set to 'unknown'");
                }
            }
            throw new AsciiTableException("AT_Renderer: cannot render unknown row type", "table row type not specified or type not processed");
        }
        ArrayList<StrBuilder> ret = ctx.getGrid().addGrid(table, ctx.getGridTheme() | ctx.getGridThemeOptions());
        int max = ret.get(0).length() + ctx.getFrameLeftMargin() + ctx.getFrameRightMargin();
        for (StrBuilder sb : ret) {
            sb.insert(0, (Object)new StrBuilder().appendPadding(ctx.getFrameLeftMargin(), ctx.getFrameLeftChar().charValue()));
            sb.appendPadding(ctx.getFrameRightMargin(), ctx.getFrameRightChar().charValue());
        }
        for (k = 0; k < ctx.getFrameTopMargin(); ++k) {
            ret.add(0, new StrBuilder().appendPadding(max, ctx.getFrameTopChar().charValue()));
        }
        for (k = 0; k < ctx.getFrameBottomMargin(); ++k) {
            ret.add(new StrBuilder().appendPadding(max, ctx.getFrameBottomChar().charValue()));
        }
        return ret;
    }

    public AT_Renderer setCWC(AT_ColumnWidthCalculator var1);

    public AT_Renderer setLineSeparator(String var1);
}

