/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciithemes;

import de.vandermeer.asciithemes.TA_CheckedItem;
import de.vandermeer.asciithemes.TA_List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public interface TA_Checklist
extends TA_List {
    public String getLabel(int var1, boolean var2);

    public int getMaxLevel();

    @Override
    default public StrBuilder toDoc() {
        if (this.getMaxLevel() == 0) {
            throw new IllegalArgumentException("checklist toDoc: max level is 0");
        }
        if (this.getMaxLevel() < -1) {
            throw new IllegalArgumentException("checklist toDoc: max level is < -1");
        }
        StrBuilder ret = new StrBuilder(30);
        ret.append(this.getLabel(1, true)).append(" checked item").appendNewLine();
        ret.append(this.getLabel(1, false)).append(" unchecked item");
        int n = 2;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(2, true)).append(" checked item").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(2, false)).append(" unchecked item");
        }
        n = 3;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(3, true)).append(" checked item").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(3, false)).append(" unchecked item");
        }
        n = 4;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(4, true)).append(" checked item").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(4, false)).append(" unchecked item");
        }
        n = 5;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(5, true)).append(" checked item").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(5, false)).append(" unchecked item");
        }
        n = 6;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(6, true)).append(" checked item").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(6, false)).append(" unchecked item");
        }
        return ret;
    }

    public static TA_Checklist create(final TA_CheckedItem item, final String description) {
        Validate.notNull((Object)item);
        Validate.notBlank((CharSequence)description);
        return new TA_Checklist(){

            @Override
            public int getMaxLevel() {
                return -1;
            }

            @Override
            public String getLabel(int level, boolean checked) {
                return item.getLabel(checked);
            }

            @Override
            public String getDescription() {
                return description;
            }
        };
    }

    public static TA_Checklist create(final String description, final TA_CheckedItem ... items) {
        Validate.notNull((Object)items);
        Validate.noNullElements((Object[])items);
        Validate.notBlank((CharSequence)description);
        return new TA_Checklist(){

            @Override
            public int getMaxLevel() {
                return items.length;
            }

            @Override
            public String getLabel(int level, boolean checked) {
                return items[level - 1].getLabel(checked);
            }

            @Override
            public String getDescription() {
                return description;
            }
        };
    }
}

