/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciithemes.a7;

import de.vandermeer.asciithemes.TA_Numbering;
import de.vandermeer.skb.interfaces.transformers.Integer_To_RomanLiteral;
import org.apache.commons.lang3.Validate;

public interface A7_NumberingSchemes {
    public static TA_Numbering blank() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                return " ";
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 1000;
            }

            @Override
            public String getDescription() {
                return "numbering scheme simply returning a blank character";
            }
        };
    }

    public static TA_Numbering Alpha() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 27 ? 1 : 0) != 0, (String)("numbering supported 0<number<27 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 64));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 26;
            }

            @Override
            public String getDescription() {
                return "numbering scheme upper case alphanumeric ASCII characters 'A-Z'";
            }
        };
    }

    public static TA_Numbering alpha() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 27 ? 1 : 0) != 0, (String)("numbering supported 0<number<27 - number was: " + number), (Object[])new Object[0]);
                return new String(Character.toChars(number + 96));
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 26;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using lower case alphanumeric ASCII characters 'a-z'";
            }
        };
    }

    public static TA_Numbering number() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 101 ? 1 : 0) != 0, (String)("numbering supported 0<number<101 - number was: " + number), (Object[])new Object[0]);
                return Integer.toString(number);
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 100;
            }

            @Override
            public String getDescription() {
                return "numbering scheme using ASCII characters for numbers '0-9'";
            }
        };
    }

    public static TA_Numbering roman() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 4001 ? 1 : 0) != 0, (String)("numbering supported 0<number<4001 - number was: " + number), (Object[])new Object[0]);
                return Integer_To_RomanLiteral.convert(number).toLowerCase();
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 4000;
            }

            @Override
            public String getDescription() {
                return "numbering scheme for Roman number literals using lower case ASCII characters";
            }
        };
    }

    public static TA_Numbering Roman() {
        return new TA_Numbering(){

            @Override
            public String getNumber(int number) {
                Validate.validState((0 < number && number < 4001 ? 1 : 0) != 0, (String)("numbering supported 0<number<4001 - number was: " + number), (Object[])new Object[0]);
                return Integer_To_RomanLiteral.convert(number);
            }

            @Override
            public int getMinNumber() {
                return 1;
            }

            @Override
            public int getMaxNumber() {
                return 4000;
            }

            @Override
            public String getDescription() {
                return "numbering scheme for Roman number literals using upper case ASCII characters";
            }
        };
    }
}

