/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces;

import org.apache.commons.lang3.Validate;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public interface FormattingTupleWrapper {
    public FormattingTuple getTuple();

    default public String getMessage() {
        return this.getTuple().getMessage();
    }

    public static FormattingTupleWrapper create(final String msg) {
        Validate.notBlank((CharSequence)msg);
        return new FormattingTupleWrapper(){

            @Override
            public FormattingTuple getTuple() {
                return MessageFormatter.arrayFormat(msg, new Object[0]);
            }
        };
    }

    public static FormattingTupleWrapper create(final String msg, final Object ... obj) {
        Validate.notBlank((CharSequence)msg);
        Validate.notNull((Object)obj);
        Validate.noNullElements((Object[])obj);
        return new FormattingTupleWrapper(){

            @Override
            public FormattingTuple getTuple() {
                return MessageFormatter.arrayFormat(msg, obj);
            }

            public String toString() {
                return this.getMessage();
            }
        };
    }
}

