/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.messagesets;

import de.vandermeer.skb.interfaces.messagesets.IsInfoSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public interface IsInfoSetFT
extends IsInfoSet<FormattingTuple> {
    default public void addAllInfos(IsInfoSetFT infos) {
        this.getInfoMessages().addAll(infos.getInfoMessages());
    }

    @Override
    default public void addInfo(String info) {
        Validate.notBlank((CharSequence)info);
        this.addInfo(MessageFormatter.arrayFormat(info, new Object[0]));
    }

    default public void addInfo(String info, Object ... obj) {
        Validate.notBlank((CharSequence)info);
        Validate.notNull((Object)obj);
        Validate.noNullElements((Object[])obj);
        this.addInfo(MessageFormatter.arrayFormat(info, obj));
    }

    @Override
    default public String render() {
        StrBuilder ret = new StrBuilder(100);
        for (FormattingTuple ft : this.getInfoMessages()) {
            ret.append(ft.getMessage()).appendNewLine();
        }
        return ret.toString();
    }

    public static IsInfoSetFT create() {
        return new IsInfoSetFT(){
            final Set<FormattingTuple> infoSet = new LinkedHashSet<FormattingTuple>();

            @Override
            public Set<FormattingTuple> getInfoMessages() {
                return this.infoSet;
            }
        };
    }
}

