/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.filters;

import com.google.common.base.Predicate;
import edu.uci.ics.jung.algorithms.filters.Filter;
import edu.uci.ics.jung.graph.Graph;

public class EdgePredicateFilter<V, E>
implements Filter<V, E> {
    protected Predicate<E> edge_pred;

    public EdgePredicateFilter(Predicate<E> edge_pred) {
        this.edge_pred = edge_pred;
    }

    public Graph<V, E> apply(Graph<V, E> g2) {
        Graph filtered;
        try {
            filtered = (Graph)g2.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create copy of existing graph: ", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create copy of existing graph: ", e);
        }
        for (Object v : g2.getVertices()) {
            filtered.addVertex(v);
        }
        for (Object e : g2.getEdges()) {
            if (!this.edge_pred.apply(e)) continue;
            filtered.addEdge(e, g2.getIncidentVertices(e));
        }
        return filtered;
    }
}

