/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.generators.GraphGenerator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import java.util.ArrayList;
import java.util.Random;

public class ErdosRenyiGenerator<V, E>
implements GraphGenerator<V, E> {
    private int mNumVertices;
    private double mEdgeConnectionProbability;
    private Random mRandom;
    Supplier<UndirectedGraph<V, E>> graphFactory;
    Supplier<V> vertexFactory;
    Supplier<E> edgeFactory;

    public ErdosRenyiGenerator(Supplier<UndirectedGraph<V, E>> graphFactory, Supplier<V> vertexFactory, Supplier<E> edgeFactory, int numVertices, double p) {
        if (numVertices <= 0) {
            throw new IllegalArgumentException("A positive # of vertices must be specified.");
        }
        this.mNumVertices = numVertices;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p must be between 0 and 1.");
        }
        this.graphFactory = graphFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.mEdgeConnectionProbability = p;
        this.mRandom = new Random();
    }

    public Graph<V, E> get() {
        UndirectedGraph g2 = (UndirectedGraph)this.graphFactory.get();
        for (int i = 0; i < this.mNumVertices; ++i) {
            g2.addVertex(this.vertexFactory.get());
        }
        ArrayList list = new ArrayList(g2.getVertices());
        for (int i = 0; i < this.mNumVertices - 1; ++i) {
            Object v_i = list.get(i);
            for (int j = i + 1; j < this.mNumVertices; ++j) {
                Object v_j = list.get(j);
                if (!(this.mRandom.nextDouble() < this.mEdgeConnectionProbability)) continue;
                g2.addEdge(this.edgeFactory.get(), v_i, v_j);
            }
        }
        return g2;
    }

    public void setSeed(long seed) {
        this.mRandom.setSeed(seed);
    }
}

