/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class BetweennessCentrality<V, E>
extends AbstractRanker<V, E> {
    public static final String CENTRALITY = "centrality.BetweennessCentrality";

    public BetweennessCentrality(Graph<V, E> g2) {
        this.initialize(g2, true, true);
    }

    public BetweennessCentrality(Graph<V, E> g2, boolean rankNodes) {
        this.initialize(g2, rankNodes, true);
    }

    public BetweennessCentrality(Graph<V, E> g2, boolean rankNodes, boolean rankEdges) {
        this.initialize(g2, rankNodes, rankEdges);
    }

    protected void computeBetweenness(Graph<V, E> graph) {
        HashMap decorator = new HashMap();
        Map bcVertexDecorator = (Map)this.vertexRankScores.getUnchecked((Object)this.getRankScoreKey());
        bcVertexDecorator.clear();
        Map bcEdgeDecorator = (Map)this.edgeRankScores.getUnchecked((Object)this.getRankScoreKey());
        bcEdgeDecorator.clear();
        Collection vertices = graph.getVertices();
        for (Object s2 : vertices) {
            this.initializeData(graph, decorator);
            ((BetweennessData)decorator.get(s2)).numSPs = 1.0;
            ((BetweennessData)decorator.get(s2)).distance = 0.0;
            Stack stack = new Stack();
            LinkedList queue = new LinkedList();
            queue.add(s2);
            while (!queue.isEmpty()) {
                Object v = queue.remove();
                stack.push(v);
                for (Object w : this.getGraph().getSuccessors(v)) {
                    if (((BetweennessData)decorator.get(w)).distance < 0.0) {
                        queue.add(w);
                        ((BetweennessData)decorator.get(w)).distance = ((BetweennessData)decorator.get(v)).distance + 1.0;
                    }
                    if (((BetweennessData)decorator.get(w)).distance != ((BetweennessData)decorator.get(v)).distance + 1.0) continue;
                    ((BetweennessData)decorator.get(w)).numSPs += ((BetweennessData)decorator.get(v)).numSPs;
                    ((BetweennessData)decorator.get(w)).predecessors.add(v);
                }
            }
            while (!stack.isEmpty()) {
                Object w = stack.pop();
                for (Object v : ((BetweennessData)decorator.get(w)).predecessors) {
                    double partialDependency = ((BetweennessData)decorator.get(v)).numSPs / ((BetweennessData)decorator.get(w)).numSPs;
                    ((BetweennessData)decorator.get(v)).dependency += (partialDependency *= 1.0 + ((BetweennessData)decorator.get(w)).dependency);
                    Object currentEdge = this.getGraph().findEdge(v, w);
                    double edgeValue = ((Number)bcEdgeDecorator.get(currentEdge)).doubleValue();
                    bcEdgeDecorator.put(currentEdge, edgeValue += partialDependency);
                }
                if (w == s2) continue;
                double bcValue = ((Number)bcVertexDecorator.get(w)).doubleValue();
                bcVertexDecorator.put(w, bcValue += ((BetweennessData)decorator.get(w)).dependency);
            }
        }
        if (graph instanceof UndirectedGraph) {
            for (Object v : vertices) {
                double bcValue = ((Number)bcVertexDecorator.get(v)).doubleValue();
                bcVertexDecorator.put(v, bcValue /= 2.0);
            }
            for (Object e : graph.getEdges()) {
                double bcValue = ((Number)bcEdgeDecorator.get(e)).doubleValue();
                bcEdgeDecorator.put(e, bcValue /= 2.0);
            }
        }
        for (Object vertex : vertices) {
            decorator.remove(vertex);
        }
    }

    private void initializeData(Graph<V, E> g2, Map<V, BetweennessData> decorator) {
        for (Object vertex : g2.getVertices()) {
            Map bcVertexDecorator = (Map)this.vertexRankScores.getUnchecked((Object)this.getRankScoreKey());
            if (!bcVertexDecorator.containsKey(vertex)) {
                bcVertexDecorator.put(vertex, 0.0);
            }
            decorator.put((BetweennessData)vertex, new BetweennessData());
        }
        for (Object e : g2.getEdges()) {
            Map bcEdgeDecorator = (Map)this.edgeRankScores.getUnchecked((Object)this.getRankScoreKey());
            if (bcEdgeDecorator.containsKey(e)) continue;
            bcEdgeDecorator.put(e, 0.0);
        }
    }

    @Override
    public String getRankScoreKey() {
        return CENTRALITY;
    }

    @Override
    public void step() {
        this.computeBetweenness(this.getGraph());
    }

    class BetweennessData {
        double distance = -1.0;
        double numSPs = 0.0;
        List<V> predecessors = new ArrayList();
        double dependency = 0.0;

        BetweennessData() {
        }
    }
}

