/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Objects;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.events.api.model.IValue;

public final class ImmutableParm
implements IParm {
    private final String parmName;
    private final IValue value;

    private ImmutableParm(Builder builder) {
        this.parmName = builder.parmName;
        this.value = builder.value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IParm parm) {
        return new Builder(parm);
    }

    public static IParm immutableCopy(IParm parm) {
        if (parm == null || parm instanceof ImmutableParm) {
            return parm;
        }
        return ImmutableParm.newBuilderFrom(parm).build();
    }

    @Override
    public String getParmName() {
        return this.parmName;
    }

    @Override
    public IValue getValue() {
        return this.value;
    }

    @Override
    public boolean isValid() {
        return this.getParmName() != null && this.getValue() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableParm that = (ImmutableParm)o;
        return Objects.equals(this.parmName, that.parmName) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.parmName, this.value);
    }

    public String toString() {
        return "ImmutableParm{parmName='" + this.parmName + "', value=" + this.value + "}";
    }

    public static final class Builder {
        private String parmName;
        private IValue value;

        private Builder() {
        }

        public Builder(IParm parm) {
            this.parmName = parm.getParmName();
            this.value = parm.getValue();
        }

        public Builder setParmName(String parmName) {
            this.parmName = parmName;
            return this;
        }

        public Builder setValue(IValue value) {
            this.value = value;
            return this;
        }

        public ImmutableParm build() {
            return new ImmutableParm(this);
        }
    }
}

