/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Objects;
import org.opennms.netmgt.events.api.model.IUpdateField;

public final class ImmutableUpdateField
implements IUpdateField {
    private final String fieldName;
    private final Boolean updateOnReduction;
    private final String valueExpression;

    private ImmutableUpdateField(Builder builder) {
        this.fieldName = builder.fieldName;
        this.updateOnReduction = builder.updateOnReduction;
        this.valueExpression = builder.valueExpression;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IUpdateField updateField) {
        return new Builder(updateField);
    }

    public static IUpdateField immutableCopyFrom(IUpdateField updateField) {
        if (updateField == null || updateField instanceof ImmutableUpdateField) {
            return updateField;
        }
        return ImmutableUpdateField.newBuilderFrom(updateField).build();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Boolean isUpdateOnReduction() {
        return this.updateOnReduction;
    }

    @Override
    public String getValueExpression() {
        return this.valueExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableUpdateField that = (ImmutableUpdateField)o;
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.updateOnReduction, that.updateOnReduction) && Objects.equals(this.valueExpression, that.valueExpression);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.updateOnReduction, this.valueExpression);
    }

    public String toString() {
        return "ImmutableUpdateField{fieldName='" + this.fieldName + "', updateOnReduction=" + this.updateOnReduction + ", valueExpression='" + this.valueExpression + "'}";
    }

    public static final class Builder {
        private String fieldName;
        private Boolean updateOnReduction;
        private String valueExpression;

        private Builder() {
        }

        public Builder(IUpdateField updateField) {
            this.fieldName = updateField.getFieldName();
            this.updateOnReduction = updateField.isUpdateOnReduction();
            this.valueExpression = updateField.getValueExpression();
        }

        public Builder setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder setUpdateOnReduction(Boolean updateOnReduction) {
            this.updateOnReduction = updateOnReduction;
            return this;
        }

        public Builder setValueExpression(String valueExpression) {
            this.valueExpression = valueExpression;
            return this;
        }

        public ImmutableUpdateField build() {
            return new ImmutableUpdateField(this);
        }
    }
}

