/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.List;
import java.util.Objects;
import org.opennms.core.utils.ImmutableCollections;
import org.opennms.core.utils.MutableCollections;
import org.opennms.netmgt.events.api.model.IMaskElement;

public final class ImmutableMaskElement
implements IMaskElement {
    private final String meName;
    private final List<String> meValues;

    private ImmutableMaskElement(Builder builder) {
        this.meName = builder.meName;
        this.meValues = ImmutableCollections.newListOfImmutableType(builder.meValues);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IMaskElement fromMaskElement) {
        return new Builder(fromMaskElement);
    }

    public static IMaskElement immutableCopy(IMaskElement maskElement) {
        if (maskElement == null || maskElement instanceof ImmutableMaskElement) {
            return maskElement;
        }
        return ImmutableMaskElement.newBuilderFrom(maskElement).build();
    }

    @Override
    public String getMename() {
        return this.meName;
    }

    @Override
    public List<String> getMevalueCollection() {
        return this.meValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMaskElement that = (ImmutableMaskElement)o;
        return Objects.equals(this.meName, that.meName) && Objects.equals(this.meValues, that.meValues);
    }

    public int hashCode() {
        return Objects.hash(this.meName, this.meValues);
    }

    public String toString() {
        return "ImmutableMaskElement{meName='" + this.meName + "', meValues=" + this.meValues + "}";
    }

    public static final class Builder {
        private String meName;
        private List<String> meValues;

        private Builder() {
        }

        public Builder(IMaskElement maskElement) {
            this.meName = maskElement.getMename();
            this.meValues = MutableCollections.copyListFromNullable(maskElement.getMevalueCollection());
        }

        public Builder setMeName(String meName) {
            this.meName = meName;
            return this;
        }

        public Builder setMeValues(List<String> meValues) {
            this.meValues = meValues;
            return this;
        }

        public ImmutableMaskElement build() {
            return new ImmutableMaskElement(this);
        }
    }
}

