/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.api;

import com.google.common.base.MoreObjects;
import io.searchbox.core.search.aggregation.MaxAggregation;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.Objects;
import org.opennms.netmgt.flows.api.BytesInOut;

public class TrafficSummary<T> {
    private final T entity;
    private final long bytesIn;
    private final long bytesOut;
    private final boolean congestionEncountered;
    private final boolean nonEcnCapableTransport;

    public TrafficSummary(Builder<T> builder) {
        this.entity = Objects.requireNonNull(builder.entity);
        this.bytesIn = builder.bytesIn;
        this.bytesOut = builder.bytesOut;
        this.congestionEncountered = builder.congestionEncountered;
        this.nonEcnCapableTransport = builder.nonEcnCapableTransport;
    }

    public T getEntity() {
        return this.entity;
    }

    public long getBytesIn() {
        return this.bytesIn;
    }

    public long getBytesOut() {
        return this.bytesOut;
    }

    public BytesInOut getBytesInOut() {
        return new BytesInOut(this.bytesIn, this.bytesOut);
    }

    public boolean isCongestionEncountered() {
        return this.congestionEncountered;
    }

    public boolean isNonEcnCapableTransport() {
        return this.nonEcnCapableTransport;
    }

    public int ecnInfo() {
        return (this.nonEcnCapableTransport ? 1 : 0) + 2 * (this.congestionEncountered ? 1 : 0);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> from(T entity) {
        return new Builder<T>().withEntity(entity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrafficSummary)) {
            return false;
        }
        TrafficSummary that = (TrafficSummary)o;
        return this.bytesIn == that.bytesIn && this.bytesOut == that.bytesOut && this.congestionEncountered == that.congestionEncountered && this.nonEcnCapableTransport == that.nonEcnCapableTransport && Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.bytesIn, this.bytesOut, this.congestionEncountered, this.nonEcnCapableTransport);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entity", this.entity).add("bytesIn", this.bytesIn).add("bytesOut", this.bytesOut).add("nonEcnCapableTransport", this.nonEcnCapableTransport).add("congestionEncountered", this.congestionEncountered).toString();
    }

    public static class Builder<T> {
        private T entity;
        private long bytesIn;
        private long bytesOut;
        private boolean congestionEncountered;
        private boolean nonEcnCapableTransport;

        private Builder() {
        }

        public Builder<T> withEntity(T entity) {
            this.entity = Objects.requireNonNull(entity);
            return this;
        }

        public Builder<T> withBytesIn(long bytesIn) {
            this.bytesIn = bytesIn;
            return this;
        }

        public Builder<T> withBytesOut(long bytesOut) {
            this.bytesOut = bytesOut;
            return this;
        }

        public Builder<T> withCongestionEncountered(boolean congestionEncountered) {
            this.congestionEncountered = congestionEncountered;
            return this;
        }

        public Builder<T> withNonEcnCapableTransport(boolean nonEcnCapableTransport) {
            this.nonEcnCapableTransport = nonEcnCapableTransport;
            return this;
        }

        public Builder<T> withEcnInfo(TrafficSummary ts) {
            this.congestionEncountered = ts.isCongestionEncountered();
            this.nonEcnCapableTransport = ts.isNonEcnCapableTransport();
            return this;
        }

        public Builder<T> withEcnInfo(MetricAggregation outerAgg) {
            MaxAggregation ceAgg = outerAgg.getMaxAggregation("congestion_encountered");
            if (ceAgg != null) {
                this.congestionEncountered = ceAgg.getMax() != null && ceAgg.getMax() > 0.0;
                MaxAggregation nonEctAgg = outerAgg.getMaxAggregation("non_ect");
                this.nonEcnCapableTransport = nonEctAgg.getMax() != null && nonEctAgg.getMax() > 0.0;
            }
            return this;
        }

        public Builder<T> withBytes(long bytesIn, long bytesOut) {
            return this.withBytesIn(bytesIn).withBytesOut(bytesOut);
        }

        public Builder<T> withBytesAndEcnInfo(TrafficSummary<?> source) {
            Objects.requireNonNull(source);
            this.bytesIn = source.getBytesIn();
            this.bytesOut = source.getBytesOut();
            return this.withEcnInfo(source);
        }

        public TrafficSummary<T> build() {
            return new TrafficSummary(this);
        }
    }
}

