/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.search;

import java.util.Objects;
import org.opennms.netmgt.graph.api.service.GraphService;

public class SearchContext {
    private final int suggestionsLimit;
    private final GraphService graphService;

    private SearchContext(int suggestionsLimit, GraphService graphService) {
        this.suggestionsLimit = suggestionsLimit;
        this.graphService = Objects.requireNonNull(graphService);
    }

    public int getSuggestionsLimit() {
        return this.suggestionsLimit;
    }

    public GraphService getGraphService() {
        return this.graphService;
    }

    public static SearchContextBuilder builder() {
        return new SearchContextBuilder();
    }

    public static final class SearchContextBuilder {
        private int suggestionsLimit = 15;
        private GraphService graphService;

        public SearchContextBuilder suggestionsLimit(int suggestionsLimit) {
            this.suggestionsLimit = suggestionsLimit;
            return this;
        }

        public SearchContextBuilder graphService(GraphService graphService) {
            this.graphService = graphService;
            return this;
        }

        public SearchContext build() {
            return new SearchContext(this.suggestionsLimit, this.graphService);
        }
    }
}

