/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.transformer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;

public class SemanticZoomLevelTransformer {
    private final Collection<GenericVertex> verticesInFocus;
    private final int szl;

    public SemanticZoomLevelTransformer(Collection<GenericVertex> verticesInFocus, int szl) {
        Preconditions.checkArgument((szl >= 0 ? 1 : 0) != 0, (Object)"Semantic Zoom Level must be >= 0");
        this.verticesInFocus = Objects.requireNonNull(verticesInFocus);
        this.szl = szl;
    }

    public GenericGraph transform(GenericGraph sourceGraph) {
        List<VertexRef> vertexRefsInFocus = this.verticesInFocus.stream().map(v -> new VertexRef(v.getNamespace(), v.getId())).collect(Collectors.toList());
        List<GenericVertex> knownVerticesInFocus = sourceGraph.resolveVertexRefs(vertexRefsInFocus);
        GenericGraph.GenericGraphBuilder graphBuilder = ((GenericGraph.GenericGraphBuilder)GenericGraph.builder().graphInfo(sourceGraph).properties((Map)sourceGraph.getProperties())).addVertices(knownVerticesInFocus);
        ArrayList alreadyProcessedVertices = new ArrayList();
        ArrayList verticesToProcess = Lists.newArrayList(knownVerticesInFocus);
        for (int i = 0; i < this.szl; ++i) {
            ArrayList tmpVertices = new ArrayList();
            for (GenericVertex eachVertex : verticesToProcess) {
                Collection<GenericVertex> neighbors = sourceGraph.getNeighbors(eachVertex);
                graphBuilder.addVertices(neighbors);
                for (GenericVertex eachNeighbor : neighbors) {
                    if (alreadyProcessedVertices.contains(eachNeighbor) || verticesToProcess.contains(eachNeighbor)) continue;
                    tmpVertices.add(eachNeighbor);
                }
            }
            alreadyProcessedVertices.addAll(verticesToProcess);
            verticesToProcess.clear();
            verticesToProcess.addAll(tmpVertices);
        }
        ArrayList<GenericEdge> edges = new ArrayList<GenericEdge>();
        for (GenericVertex eachVertex : graphBuilder.getVertices()) {
            edges.addAll(sourceGraph.getConnectingEdges(eachVertex));
        }
        List<GenericEdge> edgesToAdd = edges.stream().filter(e -> graphBuilder.getVertex(e.getSource().getId()) != null).filter(e -> graphBuilder.getVertex(e.getTarget().getId()) != null).collect(Collectors.toList());
        graphBuilder.addEdges(edgesToAdd);
        return graphBuilder.build();
    }
}

