/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.focus;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.VertexRef;

public class Focus {
    private final String id;
    private final List<VertexRef> vertexRefs;

    public Focus(String id) {
        this(id, Lists.newArrayList());
    }

    public Focus(String id, List<VertexRef> vertexRefs) {
        this.id = Objects.requireNonNull(id);
        this.vertexRefs = Objects.requireNonNull(vertexRefs);
    }

    public String getId() {
        return this.id;
    }

    public List<VertexRef> getVertexRefs() {
        return ImmutableList.copyOf(this.vertexRefs);
    }

    public List<String> getVertexIds() {
        return this.vertexRefs.stream().map(v -> v.getId()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Focus focus = (Focus)o;
        return Objects.equals(this.id, focus.id) && Objects.equals(this.vertexRefs, focus.vertexRefs);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.vertexRefs);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("vertexRefs", this.vertexRefs).toString();
    }
}

