/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.info;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;

public class DefaultGraphContainerInfo
implements GraphContainerInfo {
    private final String id;
    private List<GraphInfo> graphInfos = new ArrayList<GraphInfo>();
    private String description;
    private String label;

    public DefaultGraphContainerInfo(String id) {
        this.id = Objects.requireNonNull(id);
    }

    @Override
    public List<String> getNamespaces() {
        return this.graphInfos.stream().map(gi -> gi.getNamespace()).collect(Collectors.toList());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public GraphInfo getGraphInfo(String namespace) {
        Objects.requireNonNull(namespace);
        return this.graphInfos.stream().filter(gi -> namespace.equals(gi.getNamespace())).findFirst().orElse(null);
    }

    public void addGraphInfo(GraphInfo graphInfo) {
        this.graphInfos.add(graphInfo);
    }

    @Override
    public GraphInfo getPrimaryGraphInfo() {
        return this.graphInfos.get(0);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<GraphInfo> getGraphInfos() {
        return this.graphInfos;
    }

    public void setGraphInfos(List<GraphInfo> graphInfos) {
        this.graphInfos = graphInfos;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.graphInfos, this.description, this.label);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGraphContainerInfo that = (DefaultGraphContainerInfo)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.graphInfos, that.graphInfos) && Objects.equals(this.description, that.description) && Objects.equals(this.label, that.label);
    }
}

