/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.updates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.updates.ChangeSet;

public class ContainerChangeSet {
    private final Date changeSetDate;
    private final String containerId;
    private final List<ImmutableGraph<?, ?>> addedGraphs;
    private final List<ImmutableGraph<?, ?>> removedGraphs;
    private final List<ChangeSet<?, ?, ?>> graphChanges;

    public ContainerChangeSet(ContainerChangeSetBuilder builder) {
        Objects.requireNonNull(builder);
        this.changeSetDate = builder.changeSetDate;
        this.containerId = builder.getContainerId();
        this.addedGraphs = Collections.unmodifiableList(builder.addedGraphs);
        this.removedGraphs = Collections.unmodifiableList(builder.removedGraphs);
        this.graphChanges = Collections.unmodifiableList(builder.graphChanges);
    }

    public Date getChangeSetDate() {
        return this.changeSetDate;
    }

    public List<ImmutableGraph<?, ?>> getGraphsAdded() {
        return this.addedGraphs;
    }

    public List<ImmutableGraph<?, ?>> getGraphsRemoved() {
        return this.removedGraphs;
    }

    public List<ChangeSet<?, ?, ?>> getGraphsUpdated() {
        return this.graphChanges;
    }

    public boolean hasChanges() {
        return !this.addedGraphs.isEmpty() || !this.removedGraphs.isEmpty() || !this.graphChanges.isEmpty();
    }

    public String getContainerId() {
        return this.containerId;
    }

    public static ContainerChangeSetBuilder builder(ImmutableGraphContainer oldGraphContainer, ImmutableGraphContainer newGraphContainer) {
        return ContainerChangeSet.builder(oldGraphContainer, newGraphContainer, new Date());
    }

    public static ContainerChangeSetBuilder builder(ImmutableGraphContainer oldGraphContainer, ImmutableGraphContainer newGraphContainer, Date changeSetDate) {
        return new ContainerChangeSetBuilder(oldGraphContainer, newGraphContainer, changeSetDate);
    }

    public static final class ContainerChangeSetBuilder {
        private final ImmutableGraphContainer oldGraphContainer;
        private final ImmutableGraphContainer newGraphContainer;
        private final List<ImmutableGraph<?, ?>> addedGraphs = new ArrayList();
        private final List<ImmutableGraph<?, ?>> removedGraphs = new ArrayList();
        private final List<ChangeSet<?, ?, ?>> graphChanges = new ArrayList();
        private final Date changeSetDate;

        private ContainerChangeSetBuilder(ImmutableGraphContainer oldGraphContainer, ImmutableGraphContainer newGraphContainer, Date changeSetDate) {
            this.changeSetDate = Objects.requireNonNull(changeSetDate);
            if (oldGraphContainer == null && newGraphContainer == null) {
                throw new IllegalArgumentException("Cannot create change set if both containers are null.");
            }
            this.oldGraphContainer = oldGraphContainer;
            this.newGraphContainer = newGraphContainer;
        }

        protected String getContainerId() {
            return this.oldGraphContainer == null ? this.newGraphContainer.getId() : this.oldGraphContainer.getId();
        }

        private void detectChanges(ImmutableGraphContainer<?> oldGraphContainer, ImmutableGraphContainer<?> newGraphContainer) {
            if (oldGraphContainer == null && newGraphContainer != null) {
                newGraphContainer.getGraphs().forEach(g -> this.graphAdded((ImmutableGraph<?, ?>)g));
            }
            if (oldGraphContainer != null && newGraphContainer == null) {
                oldGraphContainer.getGraphs().forEach(g -> this.graphRemoved((ImmutableGraph<?, ?>)g));
            }
            if (oldGraphContainer == newGraphContainer) {
                return;
            }
            if (oldGraphContainer != null && newGraphContainer != null) {
                if (!oldGraphContainer.getId().equalsIgnoreCase(newGraphContainer.getId())) {
                    throw new IllegalStateException("Cannot detect changes between different containers");
                }
                List<String> oldNamespaces = oldGraphContainer.getNamespaces();
                List<String> newNamespaces = newGraphContainer.getNamespaces();
                ArrayList<String> removedNamespaces = new ArrayList<String>(oldNamespaces);
                removedNamespaces.removeAll(newNamespaces);
                removedNamespaces.forEach(ns -> {
                    Object removedGraph = oldGraphContainer.getGraph((String)ns);
                    this.graphRemoved((ImmutableGraph<?, ?>)removedGraph);
                });
                ArrayList<String> addedNamespaces = new ArrayList<String>(newNamespaces);
                addedNamespaces.removeAll(oldNamespaces);
                addedNamespaces.forEach(ns -> {
                    Object addedGraph = newGraphContainer.getGraph((String)ns);
                    this.graphAdded((ImmutableGraph<?, ?>)addedGraph);
                });
                ArrayList<String> sharedNamespaces = new ArrayList<String>(newNamespaces);
                sharedNamespaces.removeAll(addedNamespaces);
                sharedNamespaces.removeAll(removedNamespaces);
                sharedNamespaces.forEach(ns -> {
                    Object newGraph;
                    Object oldGraph = oldGraphContainer.getGraph((String)ns);
                    ChangeSet changeSet = ChangeSet.builder(oldGraph, newGraph = newGraphContainer.getGraph((String)ns)).withDate(this.changeSetDate).build();
                    if (changeSet.hasChanges()) {
                        this.graphChanged(changeSet);
                    }
                });
            }
        }

        private void graphAdded(ImmutableGraph<?, ?> newGraph) {
            this.addedGraphs.add(newGraph);
        }

        private void graphRemoved(ImmutableGraph<?, ?> removedGraph) {
            this.removedGraphs.add(removedGraph);
        }

        private void graphChanged(ChangeSet<?, ?, ?> changeSet) {
            this.graphChanges.add(changeSet);
        }

        public ContainerChangeSet build() {
            this.detectChanges(this.oldGraphContainer, this.newGraphContainer);
            return new ContainerChangeSet(this);
        }
    }
}

