/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.validation;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.graph.api.validation.exception.InvalidNamespaceException;

public class NamespaceValidator {
    protected static final String REG_EXP = "^[a-zA-Z0-9]+([.:\\-_]?[a-zA-Z0-9]*)*$";
    private static final Pattern PATTERN = Pattern.compile("^[a-zA-Z0-9]+([.:\\-_]?[a-zA-Z0-9]*)*$");

    public void validate(String namespace) {
        if (Strings.isNullOrEmpty((String)namespace)) {
            throw new InvalidNamespaceException("Namespace must not be null or empty");
        }
        Matcher matcher = PATTERN.matcher(namespace);
        if (!matcher.matches()) {
            throw new InvalidNamespaceException(REG_EXP, namespace);
        }
    }
}

