/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.validation;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.graph.api.validation.exception.InvalidGraphContainerIdException;

public class GraphContainerIdValidator {
    private static final Pattern PATTERN = Pattern.compile("^[a-zA-Z0-9]+([.:\\-_]?[a-zA-Z0-9]*)*$");

    public void validate(String containerId) {
        Objects.requireNonNull(containerId);
        if (Strings.isNullOrEmpty((String)containerId)) {
            throw new InvalidGraphContainerIdException("Id of container must nut be empty or null");
        }
        Matcher matcher = PATTERN.matcher(containerId);
        if (!matcher.matches()) {
            throw new InvalidGraphContainerIdException("^[a-zA-Z0-9]+([.:\\-_]?[a-zA-Z0-9]*)*$", containerId);
        }
    }
}

