/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.status.api.node.strategy;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.model.OnmsSeverity;

public class Status {
    final Map<Integer, OnmsSeverity> severityMap = new LinkedHashMap<Integer, OnmsSeverity>();
    final Map<Integer, Long> alarmCountMap = new LinkedHashMap<Integer, Long>();
    final Map<Integer, Long> unacknowledgedCountMap = new LinkedHashMap<Integer, Long>();

    public void add(int id, OnmsSeverity severity, long alarmCount, long unacknowledgedCount) {
        this.severityMap.put(id, severity);
        this.alarmCountMap.put(id, alarmCount);
        this.unacknowledgedCountMap.put(id, unacknowledgedCount);
    }

    public void add(int id, OnmsSeverity severity) {
        this.add(id, severity, -1L, -1L);
    }

    public OnmsSeverity getSeverity(int nodeId) {
        return this.severityMap.get(nodeId);
    }

    public int getUnacknowledgedAlarmCount(int nodeId) {
        Long value = this.unacknowledgedCountMap.get(nodeId);
        if (value != null) {
            return value.intValue();
        }
        return 0;
    }

    public List<Integer> getIds() {
        return new ArrayList<Integer>(this.severityMap.keySet());
    }

    public int size() {
        return this.severityMap.size();
    }
}

