/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.status.api;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.status.api.Query;
import org.opennms.features.status.api.SeverityFilter;
import org.opennms.features.status.api.StatusEntity;
import org.opennms.web.utils.QueryParameters;

public abstract class AbstractStatusService<T, Q extends Query> {
    public List<StatusEntity<T>> getStatus(Q query) {
        QueryParameters queryParameters = ((Query)query).getParameters();
        SeverityFilter filter = ((Query)query).getSeverityFilter();
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(queryParameters);
        if (this.isSeverityRelatedQuery(query)) {
            criteriaBuilder.offset(null);
            criteriaBuilder.limit(null);
            if (queryParameters.getOrder().getColumn().equals("severity")) {
                criteriaBuilder.clearOrder();
            }
        }
        List<StatusEntity<T>> collect = this.findMatching(query, criteriaBuilder);
        collect = this.apply(collect, filter);
        if (queryParameters.getOrder() != null && queryParameters.getOrder().getColumn().equals("severity")) {
            Comparator<StatusEntity> comparator = Comparator.comparing(StatusEntity::getStatus);
            if (queryParameters.getOrder().isDesc()) {
                comparator = comparator.reversed();
            }
            collect.sort(comparator);
            collect = this.subList(collect, queryParameters);
        }
        return collect;
    }

    private List<StatusEntity<T>> subList(List<StatusEntity<T>> list, QueryParameters queryParameters) {
        return queryParameters.getPage().apply(list);
    }

    public int count(Q query) {
        QueryParameters queryParameters = ((Query)query).getParameters();
        SeverityFilter filter = ((Query)query).getSeverityFilter();
        CriteriaBuilder builder = this.getCriteriaBuilder(queryParameters);
        builder.limit(null);
        builder.offset(null);
        builder.clearOrder();
        if (filter != null && filter.getSeverities() != null && !filter.getSeverities().isEmpty()) {
            List<StatusEntity<T>> collect = this.findMatching(query, builder);
            collect = this.apply(collect, filter);
            return collect.size();
        }
        return this.countMatching(builder.toCriteria());
    }

    protected abstract int countMatching(Criteria var1);

    protected abstract List<StatusEntity<T>> findMatching(Q var1, CriteriaBuilder var2);

    protected abstract CriteriaBuilder getCriteriaBuilder(QueryParameters var1);

    private List<StatusEntity<T>> apply(List<StatusEntity<T>> statusList, SeverityFilter severityFilter) {
        if (!statusList.isEmpty() && severityFilter != null && !severityFilter.getSeverities().isEmpty()) {
            return statusList.stream().filter(statusEntity -> severityFilter.getSeverities().contains(statusEntity.getStatus())).collect(Collectors.toList());
        }
        return statusList;
    }

    private boolean isSeverityRelatedQuery(Q query) {
        boolean severityRelatedQuery = ((Query)query).getSeverityFilter() != null && !((Query)query).getSeverityFilter().getSeverities().isEmpty() || ((Query)query).getParameters().getOrder() != null && ((Query)query).getParameters().getOrder().getColumn().equals("severity");
        return severityRelatedQuery;
    }
}

