/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeListener;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.RefComparator;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexListener;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.simple.SimpleConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGraph
implements BackendGraph {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleGraph.class);
    private final String m_namespace;
    private final Map<String, Edge> m_edgeMap = new LinkedHashMap<String, Edge>();
    private final Set<EdgeListener> m_edgeListeners = new CopyOnWriteArraySet<EdgeListener>();
    private final Map<String, Vertex> m_vertexMap = new LinkedHashMap<String, Vertex>();
    private final Set<VertexListener> m_vertexListeners = new CopyOnWriteArraySet<VertexListener>();

    public SimpleGraph(String namespace) {
        this.m_namespace = Objects.requireNonNull(namespace);
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    public boolean contributesTo(String namespace) {
        return this.m_namespace.equals(namespace);
    }

    @Override
    public Vertex getVertex(String namespace, String id) {
        return this.getVertex(new DefaultVertexRef(namespace, id), new Criteria[0]);
    }

    @Override
    public Vertex getVertex(VertexRef reference, Criteria ... criteria) {
        return this.getSimpleVertex(reference);
    }

    private Vertex getSimpleVertex(VertexRef reference) {
        if (reference != null && this.getNamespace().equals(reference.getNamespace())) {
            return this.m_vertexMap.get(reference.getId());
        }
        return null;
    }

    @Override
    public List<Vertex> getVertices(Collection<? extends VertexRef> references, Criteria ... criteria) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (VertexRef vertexRef : references) {
            Vertex vertex = this.getSimpleVertex(vertexRef);
            if (vertex == null) continue;
            vertices.add(vertex);
        }
        return vertices;
    }

    private void fireVertexSetChanged() {
        for (VertexListener listener : this.m_vertexListeners) {
            listener.vertexSetChanged(this);
        }
    }

    private void fireVerticesAdded(Collection<Vertex> vertices) {
        for (VertexListener listener : this.m_vertexListeners) {
            listener.vertexSetChanged(this, vertices, null, null);
        }
    }

    private void fireVerticesRemoved(List<? extends VertexRef> all) {
        ArrayList<String> ids = new ArrayList<String>(all.size());
        for (VertexRef vertexRef : all) {
            ids.add(vertexRef.getId());
        }
        for (VertexListener vertexListener : this.m_vertexListeners) {
            vertexListener.vertexSetChanged(this, null, null, ids);
        }
    }

    @Override
    public void addVertexListener(VertexListener vertexListener) {
        this.m_vertexListeners.add(vertexListener);
    }

    @Override
    public void removeVertexListener(VertexListener vertexListener) {
        this.m_vertexListeners.remove(vertexListener);
    }

    private void removeVertices(List<? extends VertexRef> vertices) {
        for (VertexRef vertexRef : vertices) {
            LoggerFactory.getLogger(this.getClass()).trace("Removing vertex: {}", (Object)vertexRef);
            this.m_vertexMap.remove(vertexRef.getId());
        }
        this.fireVerticesRemoved(vertices);
    }

    private void addVertices(Collection<Vertex> vertices) {
        for (Vertex vertex : vertices) {
            if (vertex.getNamespace() == null || vertex.getId() == null) {
                LoggerFactory.getLogger(this.getClass()).warn("Discarding invalid vertex: {}", (Object)vertex);
                continue;
            }
            LoggerFactory.getLogger(this.getClass()).trace("Adding vertex: {}", (Object)vertex);
            this.m_vertexMap.put(vertex.getId(), vertex);
        }
    }

    public void setVertices(List<Vertex> vertices) {
        this.clearVertices();
        this.addVertices(vertices);
        this.fireVertexSetChanged();
    }

    public void add(Vertex ... vertices) {
        this.add((Collection<Vertex>)Arrays.asList(vertices));
    }

    public void add(Collection<Vertex> vertices) {
        this.addVertices(vertices);
        this.fireVerticesAdded(vertices);
    }

    public void remove(VertexRef ... vertices) {
        this.removeVertices(Arrays.asList(vertices));
    }

    @Override
    public List<Vertex> getVertices(Criteria ... criteria) {
        return Collections.unmodifiableList(new ArrayList<Vertex>(this.m_vertexMap.values()));
    }

    @Override
    public void clearVertices() {
        List<Vertex> all = this.getVertices(new Criteria[0]);
        this.removeVertices(all);
    }

    @Override
    public int getVertexTotalCount() {
        return this.m_vertexMap.size();
    }

    @Override
    public boolean containsVertexId(String id) {
        return this.containsVertexId(new DefaultVertexRef(this.getNamespace(), id), new Criteria[0]);
    }

    @Override
    public boolean containsVertexId(VertexRef id, Criteria ... criteria) {
        return this.getVertex(id, criteria) != null;
    }

    private Edge getEdge(String id) {
        return this.m_edgeMap.get(id);
    }

    @Override
    public Edge getEdge(String namespace, String id) {
        return this.getEdge(id);
    }

    @Override
    public Edge getEdge(EdgeRef reference) {
        return this.resolveEdge(reference);
    }

    private Edge resolveEdge(EdgeRef reference) {
        if (this.getNamespace().equals(reference.getNamespace())) {
            if (reference instanceof Edge) {
                return (Edge)Edge.class.cast(reference);
            }
            return this.m_edgeMap.get(reference.getId());
        }
        return null;
    }

    @Override
    public List<Edge> getEdges(Collection<? extends EdgeRef> references) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (EdgeRef edgeRef : references) {
            Edge edge = this.resolveEdge(edgeRef);
            if (edgeRef == null) continue;
            edges.add(edge);
        }
        return Collections.unmodifiableList(edges);
    }

    private void fireEdgeSetChanged() {
        for (EdgeListener listener : this.m_edgeListeners) {
            listener.edgeSetChanged(this, null, null, null);
        }
    }

    private void fireEdgesAdded(List<Edge> edges) {
        for (EdgeListener listener : this.m_edgeListeners) {
            listener.edgeSetChanged(this, edges, null, null);
        }
    }

    private void fireEdgesRemoved(List<? extends EdgeRef> edges) {
        ArrayList<String> ids = new ArrayList<String>(edges.size());
        for (EdgeRef edgeRef : edges) {
            ids.add(edgeRef.getId());
        }
        for (EdgeListener edgeListener : this.m_edgeListeners) {
            edgeListener.edgeSetChanged(this, null, null, ids);
        }
    }

    @Override
    public void addEdgeListener(EdgeListener edgeListener) {
        this.m_edgeListeners.add(edgeListener);
    }

    @Override
    public void removeEdgeListener(EdgeListener edgeListener) {
        this.m_edgeListeners.remove(edgeListener);
    }

    @Override
    public List<Edge> getEdges(Criteria ... criteria) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : this.m_edgeMap.values()) {
            edges.add(edge.clone());
        }
        return Collections.unmodifiableList(edges);
    }

    @Override
    public void clearEdges() {
        List<Edge> all = this.getEdges(new Criteria[0]);
        this.removeEdges(all);
    }

    @Override
    public int getEdgeTotalCount() {
        return this.m_edgeMap.size();
    }

    public void setEdges(List<Edge> edges) {
        this.m_edgeMap.clear();
        this.addEdges(edges);
        this.fireEdgeSetChanged();
    }

    public void add(Edge ... edges) {
        this.add(Arrays.asList(edges));
    }

    public void add(List<Edge> edges) {
        this.addEdges(edges);
        this.fireEdgesAdded(edges);
    }

    public void remove(EdgeRef ... edges) {
        this.removeEdges(Arrays.asList(edges));
    }

    private void removeEdges(List<? extends EdgeRef> edges) {
        for (EdgeRef edgeRef : edges) {
            this.m_edgeMap.remove(edgeRef.getId());
        }
        this.fireEdgesRemoved(edges);
    }

    private void addEdges(List<Edge> edges) {
        for (Edge edge : edges) {
            if (edge.getNamespace() == null || edge.getId() == null) {
                LoggerFactory.getLogger(this.getClass()).warn("Discarding invalid edge: {}", (Object)edge);
                continue;
            }
            LoggerFactory.getLogger(this.getClass()).trace("Adding edge: {}", (Object)edge);
            this.m_edgeMap.put(edge.getId(), edge);
        }
    }

    @Override
    public void addVertices(Vertex ... vertices) {
        this.add(vertices);
    }

    @Override
    public void removeVertex(VertexRef ... vertexId) {
        this.remove(vertexId);
    }

    @Override
    public EdgeRef[] getEdgeIdsForVertex(VertexRef vertex) {
        if (vertex == null) {
            return new EdgeRef[0];
        }
        ArrayList<Edge> retval = new ArrayList<Edge>();
        for (Edge edge : this.getEdges(new Criteria[0])) {
            if (new RefComparator().compare(edge.getSource().getVertex(), vertex) != 0 && new RefComparator().compare(edge.getTarget().getVertex(), vertex) != 0) continue;
            retval.add(edge);
        }
        return retval.toArray(new EdgeRef[0]);
    }

    @Override
    public final Map<VertexRef, Set<EdgeRef>> getEdgeIdsForVertices(VertexRef ... vertices) {
        List<Edge> edges = this.getEdges(new Criteria[0]);
        HashMap<VertexRef, Set<EdgeRef>> retval = new HashMap<VertexRef, Set<EdgeRef>>();
        for (VertexRef vertex : vertices) {
            if (vertex == null) continue;
            HashSet<Edge> edgeSet = new HashSet<Edge>();
            for (Edge edge : edges) {
                if (new RefComparator().compare(edge.getSource().getVertex(), vertex) != 0 && new RefComparator().compare(edge.getTarget().getVertex(), vertex) != 0) continue;
                edgeSet.add(edge);
            }
            retval.put(vertex, edgeSet);
        }
        return retval;
    }

    @Override
    public void addEdges(Edge ... edges) {
        this.add(edges);
    }

    @Override
    public void removeEdges(EdgeRef ... edges) {
        this.remove(edges);
    }

    @Override
    public Edge connectVertices(String edgeId, VertexRef sourceVertextId, VertexRef targetVertextId) {
        return this.connectVertices(edgeId, sourceVertextId, targetVertextId, this.getNamespace());
    }

    @Override
    public void resetContainer() {
        this.clearEdges();
        this.clearVertices();
    }

    protected final AbstractEdge connectVertices(String edgeId, VertexRef sourceVertexRef, VertexRef targetVertexRef, String namespace) {
        if (sourceVertexRef == null) {
            if (targetVertexRef == null) {
                LOG.warn("Source and target vertices are null");
                return null;
            }
            LOG.warn("Source vertex is null");
            return null;
        }
        if (targetVertexRef == null) {
            LOG.warn("Target vertex is null");
            return null;
        }
        SimpleConnector source = new SimpleConnector(sourceVertexRef.getNamespace(), sourceVertexRef.getId() + "-" + edgeId + "-connector", sourceVertexRef);
        SimpleConnector target = new SimpleConnector(targetVertexRef.getNamespace(), targetVertexRef.getId() + "-" + edgeId + "-connector", targetVertexRef);
        AbstractEdge edge = new AbstractEdge(namespace, edgeId, source, target);
        this.addEdges(edge);
        return edge;
    }
}

