/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import com.google.common.base.MoreObjects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.features.topology.api.topo.SearchCriteria;
import org.opennms.features.topology.api.topo.VertexRef;

@XmlRootElement(name="search")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SearchResult {
    public static final boolean COLLAPSIBLE = true;
    public static final boolean COLLAPSED = true;
    @XmlElement(name="id")
    private String m_id;
    @XmlElement(name="namespace")
    private String m_namespace;
    @XmlElement(name="label")
    private String m_label;
    @XmlElement(name="query")
    private String m_query;
    @XmlElement(name="collapsible")
    private boolean m_collapsible = false;
    @XmlElement(name="collapsed")
    private boolean m_collapsed = false;

    public SearchResult() {
    }

    public SearchResult(String namespace, String id, String label, String query, boolean collapsible, boolean collapsed) {
        this.m_id = id;
        this.m_namespace = namespace;
        this.m_label = label;
        this.m_query = query;
        this.m_collapsible = collapsible;
        this.m_collapsed = collapsed;
    }

    public SearchResult(VertexRef vertexRef, boolean collapsible, boolean collapsed) {
        this(vertexRef.getNamespace(), vertexRef.getId(), vertexRef.getLabel(), null, collapsible, collapsed);
    }

    public SearchResult(SearchCriteria criteria) {
        this(criteria.getNamespace(), criteria.getId(), criteria.getLabel(), criteria.getSearchString(), true, criteria.isCollapsed());
    }

    public final String getId() {
        return this.m_id;
    }

    public final String getNamespace() {
        return this.m_namespace;
    }

    public final String getLabel() {
        return this.m_label;
    }

    public final String getQuery() {
        return this.m_query;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        SearchResult ref = (SearchResult)obj;
        return this.getNamespace().equals(ref.getNamespace()) && this.getId().equals(ref.getId());
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 31 * result + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.m_id).add("namespace", (Object)this.m_namespace).add("label", (Object)this.m_label).add("query", (Object)this.m_query).add("collapsible", this.m_collapsible).add("collapsed", this.m_collapsed).toString();
    }

    public final boolean isCollapsible() {
        return this.m_collapsible;
    }

    public final void setCollapsible(boolean collapsible) {
        this.m_collapsible = collapsible;
    }

    public final boolean isCollapsed() {
        return this.m_collapsed;
    }

    public final void setCollapsed(boolean collapsed) {
        this.m_collapsed = collapsed;
    }
}

