/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.support.SemanticZoomLevelCriteria;
import org.opennms.features.topology.api.support.hops.CriteriaUtils;
import org.opennms.features.topology.api.support.hops.VertexHopCriteria;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.CollapsibleCriteria;
import org.opennms.features.topology.api.topo.CollapsibleRef;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeListener;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.Ref;
import org.opennms.features.topology.api.topo.RefComparator;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexListener;
import org.opennms.features.topology.api.topo.VertexRef;

public class CollapsibleGraph
implements BackendGraph {
    private final Map<VertexRef, Integer> m_semanticZoomLevels = new LinkedHashMap<VertexRef, Integer>();
    private final BackendGraph m_delegate;

    public CollapsibleGraph(BackendGraph delegate) {
        this.m_delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public boolean containsVertexId(String id) {
        return this.containsVertexId(new DefaultVertexRef(this.getNamespace(), id), new Criteria[0]);
    }

    @Override
    public boolean containsVertexId(VertexRef id, Criteria ... criteria) {
        for (CollapsibleCriteria criterium : CriteriaUtils.getCollapsedCriteria(criteria)) {
            Vertex collapsed = criterium.getCollapsedRepresentation();
            if (new RefComparator().compare(collapsed, id) != 0) continue;
            return true;
        }
        return this.m_delegate.containsVertexId(id, criteria);
    }

    @Override
    public Vertex getVertex(String namespace, String id) {
        return this.m_delegate.getVertex(namespace, id);
    }

    @Override
    public Vertex getVertex(VertexRef reference, Criteria ... criteria) {
        for (CollapsibleCriteria criterium : CriteriaUtils.getCollapsedCriteria(criteria)) {
            Vertex collapsed = criterium.getCollapsedRepresentation();
            if (new RefComparator().compare(collapsed, reference) != 0) continue;
            return collapsed;
        }
        return this.m_delegate.getVertex(reference, criteria);
    }

    public Collection<Vertex> getVertices(int semanticZoomLevel, Criteria ... criteria) {
        ArrayList<Vertex> displayVertices = new ArrayList<Vertex>();
        for (Vertex v : this.getVertices(criteria)) {
            int vzl = this.getSemanticZoomLevel(v);
            if (vzl > semanticZoomLevel) continue;
            displayVertices.add(v);
        }
        return displayVertices;
    }

    public int getSemanticZoomLevel(VertexRef vertex) {
        Integer szl = this.m_semanticZoomLevels.get(vertex);
        return szl == null ? 0 : szl;
    }

    public Set<VertexRef> getFocusNodes(Criteria ... criteria) {
        HashSet<VertexRef> focusNodes = new HashSet<VertexRef>();
        for (Criteria criterium : criteria) {
            try {
                VertexHopCriteria hopCriterium = (VertexHopCriteria)criterium;
                focusNodes.addAll(hopCriterium.getVertices());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return focusNodes;
    }

    public int getMaxSemanticZoomLevel(Criteria ... criteria) {
        for (Criteria criterium : criteria) {
            try {
                SemanticZoomLevelCriteria szlCriteria = (SemanticZoomLevelCriteria)criterium;
                return szlCriteria.getSemanticZoomLevel();
            }
            catch (ClassCastException classCastException) {
            }
        }
        return 100;
    }

    @Override
    public List<Vertex> getVertices(Criteria ... criteria) {
        Set<VertexRef> focusNodes = this.getFocusNodes(criteria);
        int maxSemanticZoomLevel = this.getMaxSemanticZoomLevel(criteria);
        this.m_semanticZoomLevels.clear();
        int semanticZoomLevel = 0;
        if (focusNodes.size() < 1) {
            CollapsibleGraph.collapseVertices(Collections.emptySet(), CriteriaUtils.getCollapsibleCriteria(criteria, false));
        }
        HashMap<VertexRef, HashSet<VertexRef>> neighborMap = new HashMap<VertexRef, HashSet<VertexRef>>();
        List<Edge> edges = this.m_delegate.getEdges(criteria);
        for (Edge edge : edges) {
            VertexRef src = edge.getSource().getVertex();
            VertexRef tgt = edge.getTarget().getVertex();
            HashSet<VertexRef> srcNeighbors = (HashSet<VertexRef>)neighborMap.get(src);
            if (srcNeighbors == null) {
                srcNeighbors = new HashSet<VertexRef>();
                neighborMap.put(src, srcNeighbors);
            }
            srcNeighbors.add(tgt);
            HashSet<VertexRef> tgtNeighbors = (HashSet<VertexRef>)neighborMap.get(tgt);
            if (tgtNeighbors == null) {
                tgtNeighbors = new HashSet<VertexRef>();
                neighborMap.put(tgt, tgtNeighbors);
            }
            tgtNeighbors.add(src);
        }
        Set<Vertex> processed = new HashSet<Vertex>();
        HashSet neighbors = new HashSet();
        HashSet<VertexRef> workingSet = new HashSet<VertexRef>(focusNodes);
        while (semanticZoomLevel <= maxSemanticZoomLevel && workingSet.size() > 0) {
            neighbors.clear();
            for (VertexRef vertexRef : workingSet) {
                Vertex vertex = this.getVertex(vertexRef, criteria);
                if (vertex == null) continue;
                if (this.m_semanticZoomLevels.containsKey(vertexRef)) {
                    throw new IllegalStateException("Calculating semantic zoom level for vertex that has already been calculated: " + vertexRef.toString());
                }
                this.m_semanticZoomLevels.put(vertexRef, semanticZoomLevel);
                Set refs = (Set)neighborMap.get(vertexRef);
                if (refs != null) {
                    neighbors.addAll(refs);
                }
                processed.add(vertex);
            }
            neighbors.removeAll(processed);
            workingSet.clear();
            workingSet.addAll(neighbors);
            ++semanticZoomLevel;
        }
        processed = CollapsibleGraph.collapseVertices(processed, CriteriaUtils.getCollapsedCriteria(criteria));
        return new ArrayList<Vertex>(processed);
    }

    @Override
    public List<Vertex> getVertices(Collection<? extends VertexRef> references, Criteria ... criteria) {
        return this.m_delegate.getVertices(references, criteria);
    }

    @Override
    public void addVertexListener(VertexListener vertexListener) {
        this.m_delegate.addVertexListener(vertexListener);
    }

    @Override
    public void removeVertexListener(VertexListener vertexListener) {
        this.m_delegate.removeVertexListener(vertexListener);
    }

    @Override
    public void clearVertices() {
        this.m_delegate.clearVertices();
    }

    @Override
    public int getVertexTotalCount() {
        return this.m_delegate.getVertexTotalCount();
    }

    @Override
    public void addVertices(Vertex ... vertices) {
        this.m_delegate.addVertices(vertices);
    }

    @Override
    public void removeVertex(VertexRef ... vertexId) {
        this.m_delegate.removeVertex(vertexId);
    }

    @Override
    public Edge getEdge(String namespace, String id) {
        return this.m_delegate.getEdge(namespace, id);
    }

    @Override
    public Edge getEdge(EdgeRef reference) {
        return this.m_delegate.getEdge(reference);
    }

    public static Set<Vertex> collapseVertices(Set<Vertex> vertices, CollapsibleCriteria[] criteria) {
        HashSet<Vertex> retval = new HashSet<Vertex>();
        HashSet<Vertex> verticesToProcess = new HashSet<Vertex>(vertices);
        for (CollapsibleCriteria collapsibleCriteria : criteria) {
            if (!collapsibleCriteria.isCollapsed()) continue;
            Set verticesRepresentedByCollapsible = collapsibleCriteria.getVertices().stream().filter(vertices::contains).collect(Collectors.toSet());
            verticesToProcess.removeAll(verticesRepresentedByCollapsible);
            retval.add(collapsibleCriteria.getCollapsedRepresentation());
        }
        retval.addAll(verticesToProcess);
        verticesToProcess.clear();
        return retval;
    }

    public static Map<VertexRef, Set<Vertex>> getMapOfVerticesToCollapsedVertices(CollapsibleCriteria[] criteria) {
        TreeMap<Ref, HashSet<Vertex>> vertexToCollapsedVertices = new TreeMap<Ref, HashSet<Vertex>>(new RefComparator());
        for (CollapsibleCriteria criterium : criteria) {
            Set<VertexRef> criteriaVertices = criterium.getVertices();
            if (criteriaVertices.size() <= 0) continue;
            Vertex collapsedVertex = criterium.getCollapsedRepresentation();
            for (VertexRef criteriaVertex : criteriaVertices) {
                HashSet<Vertex> collapsedVertices = (HashSet<Vertex>)vertexToCollapsedVertices.get(criteriaVertex);
                if (collapsedVertices == null) {
                    collapsedVertices = new HashSet<Vertex>();
                    vertexToCollapsedVertices.put(criteriaVertex, collapsedVertices);
                }
                collapsedVertices.add(collapsedVertex);
            }
        }
        return vertexToCollapsedVertices;
    }

    public static Set<Edge> collapseEdges(Set<Edge> edges, CollapsibleCriteria[] criteria) {
        Map<VertexRef, Set<Vertex>> vertexToCollapsedVertices = CollapsibleGraph.getMapOfVerticesToCollapsedVertices(criteria);
        if (vertexToCollapsedVertices.size() > 0) {
            HashSet<Edge> retval = new HashSet<Edge>();
            for (Edge edge : edges) {
                Set<Vertex> collapsedTargets;
                boolean addOriginalEdge = true;
                Set<Vertex> collapsedSources = vertexToCollapsedVertices.get(edge.getSource().getVertex());
                if (collapsedSources != null) {
                    for (VertexRef vertexRef : collapsedSources) {
                        Edge edge2 = edge.clone();
                        edge2.setId("collapsedSource-" + edge2.getId());
                        edge2.getSource().setVertex(vertexRef);
                        retval.add(edge2);
                    }
                    addOriginalEdge = false;
                }
                if ((collapsedTargets = vertexToCollapsedVertices.get(edge.getTarget().getVertex())) != null) {
                    for (VertexRef vertexRef : collapsedTargets) {
                        Edge newCollapsedEdge = edge.clone();
                        newCollapsedEdge.setId("collapsedTarget-" + newCollapsedEdge.getId());
                        newCollapsedEdge.getTarget().setVertex(vertexRef);
                        retval.add(newCollapsedEdge);
                    }
                    addOriginalEdge = false;
                }
                if (collapsedSources != null && collapsedTargets != null) {
                    for (VertexRef vertexRef : collapsedSources) {
                        for (VertexRef vertexRef2 : collapsedTargets) {
                            Edge newCollapsedEdge = edge.clone();
                            newCollapsedEdge.setId("collapsed-" + newCollapsedEdge.getId());
                            newCollapsedEdge.getSource().setVertex(vertexRef);
                            newCollapsedEdge.getTarget().setVertex(vertexRef2);
                            retval.add(newCollapsedEdge);
                        }
                    }
                    addOriginalEdge = false;
                }
                if (!addOriginalEdge) continue;
                retval.add(edge);
            }
            return retval;
        }
        return edges;
    }

    public List<Vertex> getVertices(CollapsibleRef collapsibleRef, Criteria ... criteria) {
        for (CollapsibleCriteria criterium : CriteriaUtils.getCollapsedCriteria(criteria)) {
            if (new RefComparator().compare(criterium.getCollapsedRepresentation(), collapsibleRef) != 0) continue;
            return this.getVertices(criterium.getVertices(), new Criteria[0]);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Edge> getEdges(Criteria ... criteria) {
        Set<Edge> retval = new HashSet<Edge>(this.m_delegate.getEdges(criteria));
        retval = CollapsibleGraph.collapseEdges(retval, CriteriaUtils.getCollapsedCriteria(criteria));
        return new ArrayList<Edge>(retval);
    }

    @Override
    public List<Edge> getEdges(Collection<? extends EdgeRef> references) {
        return this.m_delegate.getEdges(references);
    }

    @Override
    public void addEdgeListener(EdgeListener listener) {
        this.m_delegate.addEdgeListener(listener);
    }

    @Override
    public void removeEdgeListener(EdgeListener listener) {
        this.m_delegate.removeEdgeListener(listener);
    }

    @Override
    public void clearEdges() {
        this.m_delegate.clearEdges();
    }

    @Override
    public int getEdgeTotalCount() {
        return this.m_delegate.getEdgeTotalCount();
    }

    @Override
    public EdgeRef[] getEdgeIdsForVertex(VertexRef vertex) {
        return this.m_delegate.getEdgeIdsForVertex(vertex);
    }

    @Override
    public Map<VertexRef, Set<EdgeRef>> getEdgeIdsForVertices(VertexRef ... vertices) {
        return this.m_delegate.getEdgeIdsForVertices(vertices);
    }

    @Override
    public void addEdges(Edge ... edges) {
        this.m_delegate.addEdges(edges);
    }

    @Override
    public void removeEdges(EdgeRef ... edges) {
        this.m_delegate.removeEdges(edges);
    }

    @Override
    public Edge connectVertices(String edgeId, VertexRef sourceVertextId, VertexRef targetVertextId) {
        return this.m_delegate.connectVertices(edgeId, sourceVertextId, targetVertextId);
    }

    @Override
    public void resetContainer() {
        this.m_delegate.resetContainer();
    }

    @Override
    public String getNamespace() {
        return this.m_delegate.getNamespace();
    }

    @Override
    public boolean contributesTo(String namespace) {
        return this.m_delegate.contributesTo(namespace);
    }
}

