/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opennms.gizmo.GizmoStack;
import org.opennms.gizmo.GizmoStacker;
import org.opennms.gizmo.junit.ExternalResourceRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GizmoRule<T extends GizmoStack<T, U>, U extends GizmoStacker<T>>
extends ExternalResourceRule {
    private static final Logger LOG = LoggerFactory.getLogger(GizmoRule.class);
    private final U stacker;
    private final List<T> stacks;
    private final boolean skipTearDown;
    private final boolean skipTearDownOnFailure;

    public GizmoRule(U stacker, List<T> stacks, boolean skipTearDown, boolean skipTearDownOnFailure) {
        this.stacker = (GizmoStacker)Objects.requireNonNull(stacker);
        this.stacks = Objects.requireNonNull(stacks);
        this.skipTearDown = skipTearDown;
        this.skipTearDownOnFailure = skipTearDownOnFailure;
    }

    @Override
    public void before() throws Exception {
        this.stacker.init();
        for (GizmoStack stack : this.stacks) {
            this.stacker.stack((GizmoStack)stack);
        }
    }

    @Override
    public void after(boolean didFail) {
        if (didFail) {
            LOG.warn("One or more tests failed.");
        }
        if (this.skipTearDown || didFail && this.skipTearDownOnFailure) {
            LOG.info("Skipping tear down.");
        } else {
            LOG.info("Tearing down...");
            this.stacker.tearDown();
        }
        try {
            this.stacker.close();
        }
        catch (IOException e) {
            LOG.error("An error occured while closting the stacker.", (Throwable)e);
        }
    }

    public U getStacker() {
        return this.stacker;
    }
}

